/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableAdHocSubProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.AdHocSubProcess;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeAdHoc;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import java.util.Collection;
import java.util.Optional;

public final class AdHocSubProcessTransformer
implements ModelElementTransformer<AdHocSubProcess> {
    @Override
    public Class<AdHocSubProcess> getType() {
        return AdHocSubProcess.class;
    }

    @Override
    public void transform(AdHocSubProcess element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableAdHocSubProcess executableAdHocSubProcess = process.getElementById(element.getId(), ExecutableAdHocSubProcess.class);
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        AdHocSubProcessTransformer.setActiveElementsCollection(executableAdHocSubProcess, element, expressionLanguage);
        Collection<AbstractFlowElement> childElements = executableAdHocSubProcess.getChildElements();
        AdHocSubProcessTransformer.setAdHocActivities(executableAdHocSubProcess, childElements);
    }

    private static void setActiveElementsCollection(ExecutableAdHocSubProcess executableAdHocSubProcess, AdHocSubProcess element, ExpressionLanguage expressionLanguage) {
        Optional.ofNullable((ZeebeAdHoc)element.getSingleExtensionElement(ZeebeAdHoc.class)).flatMap(extensionElement -> Optional.ofNullable(extensionElement.getActiveElementsCollection())).filter(expression -> !expression.isBlank()).map(arg_0 -> ((ExpressionLanguage)expressionLanguage).parseExpression(arg_0)).ifPresent(executableAdHocSubProcess::setActiveElementsCollection);
    }

    private static void setAdHocActivities(ExecutableAdHocSubProcess executableAdHocSubProcess, Collection<AbstractFlowElement> childElements) {
        childElements.stream().filter(ExecutableFlowNode.class::isInstance).map(ExecutableFlowNode.class::cast).filter(e -> AdHocSubProcessTransformer.isAdHocActivity(e.getElementType(), e.getEventType())).filter(flowElement -> flowElement.getIncoming().isEmpty()).forEach(executableAdHocSubProcess::addAdHocActivity);
    }

    private static boolean isAdHocActivity(BpmnElementType elementType, BpmnEventType eventType) {
        return switch (elementType) {
            default -> throw new MatchException(null, null);
            case BpmnElementType.UNSPECIFIED -> false;
            case BpmnElementType.SEQUENCE_FLOW -> false;
            case BpmnElementType.PROCESS, BpmnElementType.EVENT_SUB_PROCESS -> false;
            case BpmnElementType.START_EVENT, BpmnElementType.BOUNDARY_EVENT, BpmnElementType.END_EVENT -> false;
            case BpmnElementType.SUB_PROCESS, BpmnElementType.AD_HOC_SUB_PROCESS -> true;
            case BpmnElementType.TASK, BpmnElementType.MANUAL_TASK, BpmnElementType.SERVICE_TASK, BpmnElementType.USER_TASK, BpmnElementType.SCRIPT_TASK, BpmnElementType.BUSINESS_RULE_TASK -> true;
            case BpmnElementType.SEND_TASK, BpmnElementType.RECEIVE_TASK -> true;
            case BpmnElementType.EXCLUSIVE_GATEWAY, BpmnElementType.INCLUSIVE_GATEWAY, BpmnElementType.PARALLEL_GATEWAY, BpmnElementType.EVENT_BASED_GATEWAY -> true;
            case BpmnElementType.MULTI_INSTANCE_BODY -> true;
            case BpmnElementType.CALL_ACTIVITY -> true;
            case BpmnElementType.INTERMEDIATE_THROW_EVENT -> true;
            case BpmnElementType.INTERMEDIATE_CATCH_EVENT -> true;
        };
    }
}

