/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.msgpack.spec.MsgPackType;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MultiInstanceOutputCollectionBehavior {
    private final MsgPackReader outputCollectionReader = new MsgPackReader();
    private final MsgPackWriter outputCollectionWriter = new MsgPackWriter();
    private final ExpandableArrayBuffer outputCollectionBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer updatedOutputCollectionBuffer = new UnsafeBuffer(0L, 0);
    private final BpmnStateBehavior stateBehavior;
    private final ExpressionProcessor expressionProcessor;

    MultiInstanceOutputCollectionBehavior(BpmnStateBehavior stateBehavior, ExpressionProcessor expressionProcessor) {
        this.stateBehavior = stateBehavior;
        this.expressionProcessor = expressionProcessor;
    }

    public void initializeOutputCollection(BpmnElementContext context, DirectBuffer variableName, int size) {
        this.outputCollectionWriter.wrap((MutableDirectBuffer)this.outputCollectionBuffer, 0);
        this.outputCollectionWriter.writeArrayHeader(size);
        for (int i = 0; i < size; ++i) {
            this.outputCollectionWriter.writeNil();
        }
        int length = this.outputCollectionWriter.getOffset();
        this.stateBehavior.setLocalVariable(context, variableName, (DirectBuffer)this.outputCollectionBuffer, 0, length);
    }

    public Either<Failure, Void> updateOutputCollection(ExecutableMultiInstanceBody element, BpmnElementContext childContext, BpmnElementContext flowScopeContext) {
        return element.getLoopCharacteristics().getOutputCollection().map(variableName -> this.updateOutputCollection(element, childContext, flowScopeContext, (DirectBuffer)variableName)).orElse(Either.right(null));
    }

    private Either<Failure, Void> updateOutputCollection(ExecutableMultiInstanceBody element, BpmnElementContext childContext, BpmnElementContext flowScopeContext, DirectBuffer variableName) {
        int loopCounter = this.stateBehavior.getElementInstance(childContext).getMultiInstanceLoopCounter();
        return this.readOutputElementVariable(element, childContext).flatMap(elementVariable -> {
            DirectBuffer currentCollection = this.stateBehavior.getLocalVariable(flowScopeContext, variableName);
            if (currentCollection == null) {
                return Either.left((Object)new Failure("Expected the output collection variable '%s' to be of type list, but it was NIL".formatted(BufferUtil.bufferAsString((DirectBuffer)variableName)), ErrorType.EXTRACT_VALUE_ERROR, flowScopeContext.getElementInstanceKey()));
            }
            return this.replaceAt(currentCollection, loopCounter, (DirectBuffer)elementVariable, flowScopeContext.getElementInstanceKey(), variableName).map(updatedCollection -> {
                this.stateBehavior.setLocalVariable(flowScopeContext, variableName, (DirectBuffer)updatedCollection);
                return null;
            });
        });
    }

    private Either<Failure, DirectBuffer> readOutputElementVariable(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Expression expression = element.getLoopCharacteristics().getOutputElement().orElseThrow();
        return this.expressionProcessor.evaluateAnyExpression(expression, context.getElementInstanceKey());
    }

    private Either<Failure, DirectBuffer> replaceAt(DirectBuffer array, int index, DirectBuffer element, long variableScopeKey, DirectBuffer variableName) {
        this.outputCollectionReader.wrap(array, 0, array.capacity());
        MsgPackToken token = this.outputCollectionReader.readToken();
        Optional<Failure> optValidationFailure = this.validateIsCollectionAndHasAppropriateSIze(index, variableScopeKey, variableName, token);
        if (optValidationFailure.isPresent()) {
            return Either.left((Object)optValidationFailure.get());
        }
        this.outputCollectionReader.skipValues((long)index - 1L);
        int offsetBefore = this.outputCollectionReader.getOffset();
        this.outputCollectionReader.skipValue();
        int offsetAfter = this.outputCollectionReader.getOffset();
        this.outputCollectionWriter.wrap((MutableDirectBuffer)this.outputCollectionBuffer, 0);
        this.outputCollectionWriter.writeRaw(array, 0, offsetBefore);
        this.outputCollectionWriter.writeRaw(element);
        this.outputCollectionWriter.writeRaw(array, offsetAfter, array.capacity() - offsetAfter);
        int length = this.outputCollectionWriter.getOffset();
        this.updatedOutputCollectionBuffer.wrap((DirectBuffer)this.outputCollectionBuffer, 0, length);
        return Either.right((Object)this.updatedOutputCollectionBuffer);
    }

    private Optional<Failure> validateIsCollectionAndHasAppropriateSIze(int index, long variableScopeKey, DirectBuffer variableName, MsgPackToken token) {
        if (token.getType() != MsgPackType.ARRAY) {
            return Optional.of(new Failure("Unable to update an item in output collection '%s' because the type of the output collection is: %s. This may happen when multiple BPMN elements write to the same variable.".formatted(BufferUtil.bufferAsString((DirectBuffer)variableName), token.getType()), ErrorType.EXTRACT_VALUE_ERROR, variableScopeKey));
        }
        int size = token.getSize();
        if (index > size) {
            return Optional.of(new Failure("Unable to update an item in output collection '%s' at position %d because the size of the collection is: %d. This may happen when multiple BPMN elements write to the same variable.".formatted(BufferUtil.bufferAsString((DirectBuffer)variableName), index, size), ErrorType.EXTRACT_VALUE_ERROR, variableScopeKey));
        }
        return Optional.empty();
    }
}

