/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.message.MessageBatchExpireProcessor;
import io.camunda.zeebe.engine.processing.message.MessageCorrelationCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.MessageExpireProcessor;
import io.camunda.zeebe.engine.processing.message.MessageObserver;
import io.camunda.zeebe.engine.processing.message.MessagePublishProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionCreateProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionDeleteProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionMigrateProcessor;
import io.camunda.zeebe.engine.processing.message.MessageSubscriptionRejectProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageCorrelationState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageBatchIntent;
import io.camunda.zeebe.protocol.record.intent.MessageCorrelationIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.FeatureFlags;
import java.time.InstantSource;
import java.util.function.Supplier;

public final class MessageEventProcessors {
    public static void addMessageProcessors(BpmnBehaviors bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, SubscriptionCommandSender subscriptionCommandSender, Writers writers, EngineConfiguration config, FeatureFlags featureFlags, CommandDistributionBehavior commandDistributionBehavior, InstantSource clock) {
        MutableMessageState messageState = processingState.getMessageState();
        MutableMessageCorrelationState messageCorrelationState = processingState.getMessageCorrelationState();
        MutableMessageSubscriptionState subscriptionState = processingState.getMessageSubscriptionState();
        MutableMessageStartEventSubscriptionState startEventSubscriptionState = processingState.getMessageStartEventSubscriptionState();
        MutableEventScopeInstanceState eventScopeInstanceState = processingState.getEventScopeInstanceState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        MutableProcessState processState = processingState.getProcessState();
        typedRecordProcessors.onCommand(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH, new MessagePublishProcessor(messageState, subscriptionState, startEventSubscriptionState, eventScopeInstanceState, subscriptionCommandSender, keyGenerator, writers, processState, bpmnBehaviors.eventTriggerBehavior(), bpmnBehaviors.stateBehavior())).onCommand(ValueType.MESSAGE_BATCH, (Intent)MessageBatchIntent.EXPIRE, new MessageBatchExpireProcessor(writers.state())).onCommand(ValueType.MESSAGE, (Intent)MessageIntent.EXPIRE, new MessageExpireProcessor(writers.state())).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CREATE, new MessageSubscriptionCreateProcessor(processingState.getPartitionId(), messageState, subscriptionState, subscriptionCommandSender, writers, keyGenerator, clock)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, new MessageSubscriptionCorrelateProcessor(processingState.getPartitionId(), messageState, messageCorrelationState, subscriptionState, subscriptionCommandSender, writers, clock)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.DELETE, new MessageSubscriptionDeleteProcessor(subscriptionState, subscriptionCommandSender, writers)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.MIGRATE, new MessageSubscriptionMigrateProcessor(subscriptionState, writers, commandDistributionBehavior)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, new MessageSubscriptionRejectProcessor(messageState, subscriptionState, messageCorrelationState, subscriptionCommandSender, writers)).onCommand(ValueType.MESSAGE_CORRELATION, (Intent)MessageCorrelationIntent.CORRELATE, new MessageCorrelationCorrelateProcessor(writers, keyGenerator, eventScopeInstanceState, processState, bpmnBehaviors, startEventSubscriptionState, messageState, subscriptionState, subscriptionCommandSender)).withListener(new MessageObserver(scheduledTaskStateFactory, scheduledTaskStateFactory.get().getPendingMessageSubscriptionState(), subscriptionCommandSender, config.getMessagesTtlCheckerInterval(), config.getMessagesTtlCheckerBatchLimit(), featureFlags.enableMessageTTLCheckerAsync(), clock));
    }
}

