/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.metrics.EngineMetricsDoc;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.util.collection.Map3D;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public final class ProcessEngineMetrics {
    public static final String EXECUTED_EVENT_ELEMENT_TYPE_VALUE = "ROOT_PROCESS_INSTANCE";
    private static final String ORGANIZATION_ID = System.getenv().getOrDefault("CAMUNDA_CLOUD_ORGANIZATION_ID", "null");
    private final MeterRegistry registry;
    private final Map<EngineMetricsDoc.CreationMode, Counter> createdRootProcessInstances = new EnumMap<EngineMetricsDoc.CreationMode, Counter>(EngineMetricsDoc.CreationMode.class);
    private final Map3D<EngineMetricsDoc.EngineAction, BpmnElementType, BpmnEventType, Counter> elementInstanceEvents = Map3D.ofEnum(EngineMetricsDoc.EngineAction.class, BpmnElementType.class, BpmnEventType.class, Counter[]::new);
    private final Map<EngineMetricsDoc.EngineAction, Counter> executedEvents = new EnumMap<EngineMetricsDoc.EngineAction, Counter>(EngineMetricsDoc.EngineAction.class);
    private final Map<EngineMetricsDoc.EngineAction, Counter> evaluatedDmnElements = new EnumMap<EngineMetricsDoc.EngineAction, Counter>(EngineMetricsDoc.EngineAction.class);

    public ProcessEngineMetrics(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "must specify a registry");
    }

    public void processInstanceCreated(ProcessInstanceCreationRecord instanceCreationRecord) {
        EngineMetricsDoc.CreationMode creationMode = instanceCreationRecord.hasStartInstructions() ? EngineMetricsDoc.CreationMode.CREATION_AT_GIVEN_ELEMENT : EngineMetricsDoc.CreationMode.CREATION_AT_DEFAULT_START_EVENT;
        this.createdRootProcessInstances.computeIfAbsent(creationMode, this::registerCreatedRootProcessInstanceCounter).increment();
    }

    public void elementInstanceActivated(BpmnElementContext context, BpmnEventType eventType) {
        BpmnElementType elementType = context.getBpmnElementType();
        BpmnEventType eventTypeName = this.extractEventTypeName(eventType);
        this.elementInstanceEvent(EngineMetricsDoc.EngineAction.ACTIVATED, elementType, eventTypeName);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(EngineMetricsDoc.EngineAction.ACTIVATED);
        }
    }

    public void elementInstanceCompleted(BpmnElementContext context, BpmnEventType eventType) {
        BpmnElementType elementType = context.getBpmnElementType();
        BpmnEventType eventTypeName = this.extractEventTypeName(eventType);
        this.elementInstanceEvent(EngineMetricsDoc.EngineAction.COMPLETED, elementType, eventTypeName);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(EngineMetricsDoc.EngineAction.COMPLETED);
        }
    }

    public void elementInstanceTerminated(BpmnElementContext context, BpmnEventType eventType) {
        BpmnElementType elementType = context.getBpmnElementType();
        BpmnEventType eventTypeName = this.extractEventTypeName(eventType);
        this.elementInstanceEvent(EngineMetricsDoc.EngineAction.TERMINATED, elementType, eventTypeName);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(EngineMetricsDoc.EngineAction.TERMINATED);
        }
    }

    public void increaseSuccessfullyEvaluatedDmnElements(int amount) {
        this.increaseEvaluatedDmnElements(EngineMetricsDoc.EngineAction.EVALUATED_SUCCESSFULLY, amount);
    }

    public void increaseFailedEvaluatedDmnElements(int amount) {
        this.increaseEvaluatedDmnElements(EngineMetricsDoc.EngineAction.EVALUATED_FAILED, amount);
    }

    private void elementInstanceEvent(EngineMetricsDoc.EngineAction action, BpmnElementType elementType, BpmnEventType eventType) {
        ((Counter)this.elementInstanceEvents.computeIfAbsent((Object)action, (Object)elementType, (Object)eventType, this::registerElementInstanceEventCounter)).increment();
    }

    private void increaseRootProcessInstance(EngineMetricsDoc.EngineAction action) {
        this.executedEvents.computeIfAbsent(action, this::registerExecutedEventCounter).increment();
    }

    private void increaseEvaluatedDmnElements(EngineMetricsDoc.EngineAction action, int amount) {
        this.evaluatedDmnElements.computeIfAbsent(action, this::registerEvaluatedDmnElementCounter).increment((double)amount);
    }

    private boolean isProcessInstance(BpmnElementType elementType) {
        return BpmnElementType.PROCESS == elementType;
    }

    private boolean isRootProcessInstance(BpmnElementType elementType, long parentProcessInstanceKey) {
        return this.isProcessInstance(elementType) && parentProcessInstanceKey == -1L;
    }

    private BpmnEventType extractEventTypeName(BpmnEventType eventType) {
        return eventType != null ? eventType : BpmnEventType.UNSPECIFIED;
    }

    private Counter registerCreatedRootProcessInstanceCounter(EngineMetricsDoc.CreationMode creationMode) {
        EngineMetricsDoc meterDoc = EngineMetricsDoc.CREATED_ROOT_PROCESS_INSTANCES;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.CREATION_MODE.asString(), creationMode.toString()).tag(EngineMetricsDoc.EngineKeyNames.ORGANIZATION_ID.asString(), ORGANIZATION_ID).register(this.registry);
    }

    private Counter registerElementInstanceEventCounter(EngineMetricsDoc.EngineAction engineAction, BpmnElementType bpmnElementType, BpmnEventType bpmnEventType) {
        EngineMetricsDoc meterDoc = EngineMetricsDoc.ELEMENT_INSTANCE_EVENTS;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.ACTION.asString(), engineAction.toString()).tag(EngineMetricsDoc.EngineKeyNames.ELEMENT_TYPE.asString(), bpmnElementType.name()).tag(EngineMetricsDoc.EngineKeyNames.EVENT_TYPE.asString(), bpmnEventType.name()).register(this.registry);
    }

    private Counter registerExecutedEventCounter(EngineMetricsDoc.EngineAction engineAction) {
        EngineMetricsDoc meterDoc = EngineMetricsDoc.EXECUTED_EVENTS;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.ACTION.asString(), engineAction.toString()).tag(EngineMetricsDoc.EngineKeyNames.ELEMENT_TYPE.asString(), EXECUTED_EVENT_ELEMENT_TYPE_VALUE).tag(EngineMetricsDoc.EngineKeyNames.ORGANIZATION_ID.asString(), ORGANIZATION_ID).register(this.registry);
    }

    private Counter registerEvaluatedDmnElementCounter(EngineMetricsDoc.EngineAction engineAction) {
        EngineMetricsDoc meterDoc = EngineMetricsDoc.EVALUATED_DMN_ELEMENTS;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(EngineMetricsDoc.EngineKeyNames.ACTION.asString(), engineAction.toString()).tag(EngineMetricsDoc.EngineKeyNames.ORGANIZATION_ID.asString(), ORGANIZATION_ID).register(this.registry);
    }
}

