/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum EngineMetricsDoc implements ExtendedMeterDocumentation
{
    CREATED_ROOT_PROCESS_INSTANCES{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.CREATION_MODE};

        public String getName() {
            return "zeebe.process.instance.creations.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "Number of created (root) process instances";
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    ELEMENT_INSTANCE_EVENTS{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.ACTION, EngineKeyNames.ELEMENT_TYPE, EngineKeyNames.EVENT_TYPE};

        public String getDescription() {
            return "Number of process element instance events";
        }

        public String getName() {
            return "zeebe.element.instance.events.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    EXECUTED_EVENTS{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.ACTION, EngineKeyNames.ELEMENT_TYPE, EngineKeyNames.ORGANIZATION_ID};

        public String getDescription() {
            return "Number of executed (root) process instances";
        }

        public String getName() {
            return "zeebe.executed.instances.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    EVALUATED_DMN_ELEMENTS{
        private static final KeyName[] KEY_NAMES = new KeyName[]{EngineKeyNames.ACTION, EngineKeyNames.ORGANIZATION_ID};

        public String getDescription() {
            return "Number of evaluated DMN elements including required decisions";
        }

        public String getName() {
            return "zeebe.evaluated.dmn.elements.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return KEY_NAMES;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    };


    public static enum EngineAction {
        ACTIVATED,
        COMPLETED,
        TERMINATED,
        EVALUATED_SUCCESSFULLY,
        EVALUATED_FAILED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum CreationMode {
        CREATION_AT_DEFAULT_START_EVENT,
        CREATION_AT_GIVEN_ELEMENT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EngineKeyNames implements KeyName
    {
        CREATION_MODE{

            public String asString() {
                return "creation_mode";
            }
        }
        ,
        ACTION{

            public String asString() {
                return "action";
            }
        }
        ,
        ELEMENT_TYPE{

            public String asString() {
                return "type";
            }
        }
        ,
        EVENT_TYPE{

            public String asString() {
                return "eventType";
            }
        }
        ,
        ORGANIZATION_ID{

            public String asString() {
                return "organizationId";
            }
        };

    }
}

