/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import io.camunda.zeebe.util.FeatureFlags;
import java.time.Duration;
import java.time.InstantSource;
import java.util.function.Function;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private static final double GIVE_YIELD_FACTOR = 0.5;
    private final DueDateChecker dueDateChecker;

    public DueDateTimerChecker(TimerInstanceState timerInstanceState, FeatureFlags featureFlags, InstantSource clock) {
        this.dueDateChecker = new DueDateChecker(TIMER_RESOLUTION, featureFlags.enableTimerDueDateCheckerAsync(), new TriggerTimersSideEffect(timerInstanceState, clock, featureFlags.yieldingDueDateChecker()), clock);
    }

    public void scheduleTimer(long dueDate) {
        this.dueDateChecker.schedule(dueDate);
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.dueDateChecker.onRecovered(context);
    }

    public void onClose() {
        this.dueDateChecker.onClose();
    }

    public void onFailed() {
        this.dueDateChecker.onFailed();
    }

    public void onPaused() {
        this.dueDateChecker.onPaused();
    }

    public void onResumed() {
        this.dueDateChecker.onResumed();
    }

    protected static final class TriggerTimersSideEffect
    implements Function<TaskResultBuilder, Long> {
        private final InstantSource clock;
        private final TimerInstanceState timerInstanceState;
        private final boolean yieldControl;

        public TriggerTimersSideEffect(TimerInstanceState timerInstanceState, InstantSource clock, boolean yieldControl) {
            this.timerInstanceState = timerInstanceState;
            this.clock = clock;
            this.yieldControl = yieldControl;
        }

        @Override
        public Long apply(TaskResultBuilder taskResultBuilder) {
            long now = this.clock.millis();
            long yieldAfter = now + Math.round((double)TIMER_RESOLUTION * 0.5);
            TimerInstanceState.TimerVisitor timerVisitor = this.yieldControl ? new YieldingDecorator(this.clock, yieldAfter, new WriteTriggerTimerCommandVisitor(taskResultBuilder)) : new WriteTriggerTimerCommandVisitor(taskResultBuilder);
            return this.timerInstanceState.processTimersWithDueDateBefore(now, timerVisitor);
        }
    }

    protected static final class YieldingDecorator
    implements TimerInstanceState.TimerVisitor {
        private final TimerInstanceState.TimerVisitor delegate;
        private final InstantSource clock;
        private final long giveYieldAfter;

        public YieldingDecorator(InstantSource clock, long giveYieldAfter, TimerInstanceState.TimerVisitor delegate) {
            this.delegate = delegate;
            this.clock = clock;
            this.giveYieldAfter = giveYieldAfter;
        }

        @Override
        public boolean visit(TimerInstance timer) {
            if (this.clock.millis() >= this.giveYieldAfter) {
                return false;
            }
            return this.delegate.visit(timer);
        }
    }

    protected static final class WriteTriggerTimerCommandVisitor
    implements TimerInstanceState.TimerVisitor {
        private final TimerRecord timerRecord = new TimerRecord();
        private final TaskResultBuilder taskResultBuilder;

        public WriteTriggerTimerCommandVisitor(TaskResultBuilder taskResultBuilder) {
            this.taskResultBuilder = taskResultBuilder;
        }

        @Override
        public boolean visit(TimerInstance timer) {
            this.timerRecord.reset();
            this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setTargetElementId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setProcessDefinitionKey(timer.getProcessDefinitionKey()).setTenantId(timer.getTenantId());
            return this.taskResultBuilder.appendCommandRecord(timer.getKey(), (Intent)TimerIntent.TRIGGER, (UnifiedRecordValue)this.timerRecord);
        }
    }
}

