/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.job.JobCommandPreconditionChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.List;

public final class JobYieldProcessor
implements TypedRecordProcessor<JobRecord> {
    private final JobState jobState;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final JobCommandPreconditionChecker preconditionChecker;

    public JobYieldProcessor(ProcessingState state, BpmnBehaviors bpmnBehaviors, Writers writers) {
        this.jobState = state.getJobState();
        this.jobActivationBehavior = bpmnBehaviors.jobActivationBehavior();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.preconditionChecker = new JobCommandPreconditionChecker("yield", List.of(JobState.State.ACTIVATED));
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        this.preconditionChecker.check(state, jobKey).ifRightOrLeft(ok -> {
            JobRecord yieldedJob = this.jobState.getJob(jobKey);
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.YIELDED, (RecordValue)yieldedJob);
            this.jobActivationBehavior.notifyJobAvailableAsSideEffect(yieldedJob);
        }, violation -> this.rejectionWriter.appendRejection((TypedRecord<? extends RecordValue>)record, (RejectionType)violation.getLeft(), (String)violation.getRight()));
    }
}

