/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;

public final class UserTaskCreatingApplier
implements TypedEventApplier<UserTaskIntent, UserTaskRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableUserTaskState userTaskState;

    public UserTaskCreatingApplier(MutableProcessingState processingState) {
        this.elementInstanceState = processingState.getElementInstanceState();
        this.userTaskState = processingState.getUserTaskState();
    }

    @Override
    public void applyState(long key, UserTaskRecord value) {
        ElementInstance elementInstance;
        this.userTaskState.create(value);
        long elementInstanceKey = value.getElementInstanceKey();
        if (elementInstanceKey > 0L && (elementInstance = this.elementInstanceState.getInstance(elementInstanceKey)) != null) {
            elementInstance.setUserTaskKey(key);
            this.elementInstanceState.updateInstance(elementInstance);
        }
    }
}

