/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskSupportingProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBusinessRuleTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;

public final class BusinessRuleTaskProcessor
extends JobWorkerTaskSupportingProcessor<ExecutableBusinessRuleTask> {
    private final BpmnDecisionBehavior decisionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnStateBehavior stateBehavior;

    public BusinessRuleTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        super(bpmnBehaviors, stateTransitionBehavior);
        this.decisionBehavior = bpmnBehaviors.bpmnDecisionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
    }

    @Override
    public Class<ExecutableBusinessRuleTask> getType() {
        return ExecutableBusinessRuleTask.class;
    }

    @Override
    protected boolean isJobBehavior(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        if (element.getDecisionId() != null) {
            return false;
        }
        if (element.getJobWorkerProperties() == null) {
            throw new BpmnProcessingException(context, "Expected to process business rule task, but could not determine processing behavior");
        }
        return true;
    }

    @Override
    public void onActivateInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.decisionBehavior.evaluateDecision(element, context)).ifRightOrLeft(ok -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
            this.stateTransitionBehavior.completeElement(activated);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onCompleteInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, context)).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminateInternal(ExecutableBusinessRuleTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

