/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableUserTask;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.ExpressionTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.immutable.FormState;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public final class BpmnUserTaskBehavior {
    private static final Set<UserTaskState.LifecycleState> CANCELABLE_LIFECYCLE_STATES = EnumSet.of(UserTaskState.LifecycleState.CREATING, UserTaskState.LifecycleState.CREATED);
    private final UserTaskRecord userTaskRecord = new UserTaskRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final FormState formState;
    private final MutableUserTaskState userTaskState;

    public BpmnUserTaskBehavior(KeyGenerator keyGenerator, Writers writers, ExpressionProcessor expressionBehavior, BpmnStateBehavior stateBehavior, FormState formState, MutableUserTaskState userTaskState) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.expressionBehavior = expressionBehavior;
        this.stateBehavior = stateBehavior;
        this.formState = formState;
        this.userTaskState = userTaskState;
    }

    public Either<Failure, UserTaskProperties> evaluateUserTaskExpressions(ExecutableUserTask element, BpmnElementContext context) {
        io.camunda.zeebe.engine.processing.deployment.model.element.UserTaskProperties userTaskProps = element.getUserTaskProperties();
        long scopeKey = context.getElementInstanceKey();
        String tenantId = context.getTenantId();
        return Either.right((Object)new UserTaskProperties()).flatMap(p -> this.evaluateAssigneeExpression(userTaskProps.getAssignee(), scopeKey).map(p::assignee)).flatMap(p -> this.evaluateCandidateGroupsExpression(userTaskProps.getCandidateGroups(), scopeKey).map(p::candidateGroups)).flatMap(p -> this.evaluateCandidateUsersExpression(userTaskProps.getCandidateUsers(), scopeKey).map(p::candidateUsers)).flatMap(p -> this.evaluateDateExpression(userTaskProps.getDueDate(), scopeKey).map(p::dueDate)).flatMap(p -> this.evaluateDateExpression(userTaskProps.getFollowUpDate(), scopeKey).map(p::followUpDate)).flatMap(p -> this.evaluateFormIdExpressionToFormKey(userTaskProps.getFormId(), scopeKey, tenantId).map(p::formKey));
    }

    public long createNewUserTask(BpmnElementContext context, ExecutableUserTask element, UserTaskProperties userTaskProperties) {
        long userTaskKey = this.keyGenerator.nextKey();
        this.writeUserTaskEvent(userTaskKey, context, element, UserTaskIntent.CREATING, userTaskProperties);
        return userTaskKey;
    }

    public void userTaskCreated(long userTaskKey, BpmnElementContext context, ExecutableUserTask element, UserTaskProperties userTaskProperties) {
        this.writeUserTaskEvent(userTaskKey, context, element, UserTaskIntent.CREATED, userTaskProperties);
    }

    public Either<Failure, String> evaluateAssigneeExpression(Expression assignee, long scopeKey) {
        if (assignee == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateStringExpression(assignee, scopeKey);
    }

    public Either<Failure, String> evaluateCandidateGroupsExpression(Expression candidateGroups, long scopeKey) {
        if (candidateGroups == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateArrayOfStringsExpression(candidateGroups, scopeKey).map(ExpressionTransformer::asListLiteral);
    }

    public Either<Failure, String> evaluateCandidateUsersExpression(Expression candidateUsers, long scopeKey) {
        if (candidateUsers == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateArrayOfStringsExpression(candidateUsers, scopeKey).map(ExpressionTransformer::asListLiteral);
    }

    public Either<Failure, String> evaluateDateExpression(Expression date, long scopeKey) {
        if (date == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateDateTimeExpression(date, scopeKey, true).map(optionalDate -> optionalDate.map(ZonedDateTime::toString).orElse(null));
    }

    public Either<Failure, Long> evaluateFormIdExpressionToFormKey(Expression formIdExpression, long scopeKey, String tenantId) {
        if (formIdExpression == null) {
            return Either.right(null);
        }
        return this.expressionBehavior.evaluateStringExpression(formIdExpression, scopeKey).flatMap(formId -> {
            Optional<PersistedForm> latestFormById = this.formState.findLatestFormById(BufferUtil.wrapString((String)formId), tenantId);
            return latestFormById.map(persistedForm -> Either.right((Object)persistedForm.getFormKey())).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to find a form with id '%s', but no form with this id is found, at least a form with this id should be available. To resolve the Incident please deploy a form with the same id", formId), ErrorType.FORM_NOT_FOUND, scopeKey)));
        });
    }

    public void cancelUserTask(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        this.cancelUserTask(elementInstance);
    }

    public void cancelUserTask(ElementInstance elementInstance) {
        UserTaskState.LifecycleState lifecycleState;
        long userTaskKey = elementInstance.getUserTaskKey();
        if (userTaskKey > 0L && CANCELABLE_LIFECYCLE_STATES.contains((Object)(lifecycleState = this.userTaskState.getLifecycleState(userTaskKey)))) {
            UserTaskRecord userTask = this.userTaskState.getUserTask(userTaskKey);
            this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.CANCELING, (RecordValue)userTask);
            this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)UserTaskIntent.CANCELED, (RecordValue)userTask);
        }
    }

    private void writeUserTaskEvent(long userTaskKey, BpmnElementContext context, ExecutableUserTask userTask, UserTaskIntent intent, UserTaskProperties props) {
        this.userTaskRecord.setUserTaskKey(userTaskKey).setAssignee(props.getAssignee()).setCandidateGroups(props.getCandidateGroups()).setCandidateUsers(props.getCandidateUsers()).setDueDate(props.getDueDate()).setFollowUpDate(props.getFollowUpDate()).setFormKey(props.getFormKey().longValue()).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(userTask.getId()).setElementInstanceKey(context.getElementInstanceKey()).setTenantId(context.getTenantId());
        this.stateWriter.appendFollowUpEvent(userTaskKey, (Intent)intent, (RecordValue)this.userTaskRecord);
    }

    public static final class UserTaskProperties {
        private String assignee;
        private String candidateGroups;
        private String candidateUsers;
        private String dueDate;
        private String followUpDate;
        private Long formKey;

        public String getAssignee() {
            return UserTaskProperties.getOrEmpty(this.assignee);
        }

        public UserTaskProperties assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public String getCandidateGroups() {
            return UserTaskProperties.getOrEmpty(this.candidateGroups);
        }

        public UserTaskProperties candidateGroups(String candidateGroups) {
            this.candidateGroups = candidateGroups;
            return this;
        }

        public String getCandidateUsers() {
            return UserTaskProperties.getOrEmpty(this.candidateUsers);
        }

        public UserTaskProperties candidateUsers(String candidateUsers) {
            this.candidateUsers = candidateUsers;
            return this;
        }

        public String getDueDate() {
            return UserTaskProperties.getOrEmpty(this.dueDate);
        }

        public UserTaskProperties dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public String getFollowUpDate() {
            return UserTaskProperties.getOrEmpty(this.followUpDate);
        }

        public UserTaskProperties followUpDate(String followUpDate) {
            this.followUpDate = followUpDate;
            return this;
        }

        public Long getFormKey() {
            return this.formKey == null ? -1L : this.formKey;
        }

        public UserTaskProperties formKey(Long formKey) {
            this.formKey = formKey;
            return this;
        }

        private static String getOrEmpty(String stringValue) {
            return stringValue == null ? "" : stringValue;
        }
    }
}

