/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;

public final class BoundedMeterCache<T extends Meter> {
    private final LoadingCache<String, T> meters;

    private BoundedMeterCache(LoadingCache<String, T> meters) {
        this.meters = meters;
    }

    public static <T extends Meter> BoundedMeterCache<T> of(MeterRegistry registry, Meter.MeterProvider<T> provider, KeyName tagKey) {
        return BoundedMeterCache.of(registry, provider, tagKey, 500);
    }

    public static <T extends Meter> BoundedMeterCache<T> of(MeterRegistry registry, Meter.MeterProvider<T> provider, KeyName tagKey, int maxSize) {
        Caffeine builder = Caffeine.newBuilder().maximumSize((long)maxSize).evictionListener(BoundedMeterCache.removeEvictedMeter(registry));
        return new BoundedMeterCache<T>(builder.build(v -> provider.withTag(tagKey.asString(), v)));
    }

    public T get(String tagValue) {
        return (T)((Meter)this.meters.get((Object)tagValue));
    }

    private static <K, T extends Meter> RemovalListener<K, T> removeEvictedMeter(MeterRegistry registry) {
        return (labels, gauge, ignored) -> BoundedMeterCache.removeEvictedMeter(registry, gauge);
    }

    private static <T extends Meter> void removeEvictedMeter(MeterRegistry registry, T value) {
        if (value != null) {
            registry.remove(value);
        }
    }
}

