/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import io.camunda.zeebe.util.collection.MArray;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public interface Table<RowT, ColT, T> {
    public T get(RowT var1, ColT var2);

    public void put(RowT var1, ColT var2, T var3);

    public T computeIfAbsent(RowT var1, ColT var2, BiFunction<RowT, ColT, T> var3);

    public static <RowT, ColT, T> Table<RowT, ColT, T> simple() {
        return new MapTable();
    }

    public static <RowT, ColT, T> Table<RowT, ColT, T> concurrent() {
        return new MapTable(ConcurrentHashMap::new);
    }

    public static <RowT extends Enum<RowT>, ColT extends Enum<ColT>, T> Table<RowT, ColT, T> ofEnum(Class<RowT> rowClass, Class<ColT> columnClass, IntFunction<T[]> arraySupplier) {
        MArray marray = MArray.of(arraySupplier, ((Enum[])rowClass.getEnumConstants()).length, ((Enum[])columnClass.getEnumConstants()).length);
        return new EnumTable(marray);
    }

    public static final class MapTable<RowT, ColT, T>
    implements Table<RowT, ColT, T> {
        private final Map<RowT, Map<ColT, T>> table;
        private final Supplier<Map<?, ?>> supplier;

        private MapTable() {
            this(HashMap::new);
        }

        private MapTable(Supplier<Map<?, ?>> supplier) {
            this.supplier = supplier;
            this.table = supplier.get();
        }

        @Override
        public T get(RowT rowKey, ColT columnKey) {
            Map<ColT, T> row = this.table.get(rowKey);
            if (row == null) {
                return null;
            }
            return row.get(columnKey);
        }

        @Override
        public void put(RowT rowKey, ColT columnKey, T value) {
            this.table.computeIfAbsent(rowKey, ignored -> this.supplier.get()).put(columnKey, value);
        }

        @Override
        public T computeIfAbsent(RowT rowKey, ColT columnKey, BiFunction<RowT, ColT, T> computer) {
            return (T)this.table.computeIfAbsent(rowKey, ignored -> this.supplier.get()).computeIfAbsent(columnKey, ignored -> computer.apply(rowKey, columnKey));
        }
    }

    public static final class EnumTable<RowT extends Enum<RowT>, ColT extends Enum<ColT>, T>
    implements Table<RowT, ColT, T> {
        private final MArray<T> marray;

        private EnumTable(MArray<T> marray) {
            if (marray.dimensions() != 2) {
                throw new IllegalArgumentException("Expected a 2D m-array, but got %d dimensions".formatted(marray.dimensions()));
            }
            this.marray = marray;
        }

        @Override
        public T get(RowT rowKey, ColT columnKey) {
            return this.marray.get(((Enum)rowKey).ordinal(), ((Enum)columnKey).ordinal());
        }

        @Override
        public void put(RowT rowKey, ColT columnKey, T value) {
            this.marray.put(value, ((Enum)rowKey).ordinal(), ((Enum)columnKey).ordinal());
        }

        @Override
        public T computeIfAbsent(RowT rowKey, ColT columnKey, BiFunction<RowT, ColT, T> computer) {
            T value = this.marray.get(((Enum)rowKey).ordinal(), ((Enum)columnKey).ordinal());
            if (value != null) {
                return value;
            }
            T updated = computer.apply(rowKey, columnKey);
            this.marray.put(updated, ((Enum)rowKey).ordinal(), ((Enum)columnKey).ordinal());
            return updated;
        }
    }
}

