/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import io.camunda.zeebe.util.health.MemoryHealthIndicatorProperties;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Before;
import org.junit.Test;

public class LivenessMemoryHealthIndicatorPropertiesTest {
    private MemoryHealthIndicatorProperties sutProperties;

    @Before
    public void setUp() {
        this.sutProperties = new MemoryHealthIndicatorProperties();
    }

    @Test
    public void shouldHaveDefaultThresholdOfTenPercent() {
        double actual = this.sutProperties.getThreshold();
        Assertions.assertThat((double)actual).isEqualTo(0.1, Offset.offset((Number)1.0E-4));
    }

    @Test
    public void shouldRejectNegativeThreshold() {
        Assertions.assertThatThrownBy(() -> this.sutProperties.setThreshold(-0.5)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((double)this.sutProperties.getThreshold()).isEqualTo(0.1, Offset.offset((Number)1.0E-4));
    }

    @Test
    public void shouldRejectZeroThreshold() {
        Assertions.assertThatThrownBy(() -> this.sutProperties.setThreshold(0.0)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((double)this.sutProperties.getThreshold()).isEqualTo(0.1, Offset.offset((Number)1.0E-4));
    }

    @Test
    public void shouldRejectOneThreshold() {
        Assertions.assertThatThrownBy(() -> this.sutProperties.setThreshold(1.0)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((double)this.sutProperties.getThreshold()).isEqualTo(0.1, Offset.offset((Number)1.0E-4));
    }

    @Test
    public void shouldRejectGreaterThanOneThreshold() {
        Assertions.assertThatThrownBy(() -> this.sutProperties.setThreshold(1.5)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((double)this.sutProperties.getThreshold()).isEqualTo(0.1, Offset.offset((Number)1.0E-4));
    }

    @Test
    public void shouldApplyNewThreshold() {
        this.sutProperties.setThreshold(0.5);
        double actual = this.sutProperties.getThreshold();
        Assertions.assertThat((double)actual).isEqualTo(0.5, Offset.offset((Number)1.0E-4));
    }
}

