/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.ByteValue;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ByteValueTest {
    @Parameterized.Parameter(value=0)
    public long input;
    @Parameterized.Parameter(value=1)
    public String expected;

    @Parameterized.Parameters(name="Byte value {0} -> {1}")
    public static Object[][] parameters() {
        return new Object[][]{{0, "0 B"}, {1024, "1.0 KB"}, {1500, "1.5 KB"}, {0x100000, "1.0 MB"}, {0x380000, "3.5 MB"}, {0x2300000, "35.0 MB"}};
    }

    @Test
    public void shouldPrettyPrintByteValue() {
        String actual = ByteValue.prettyPrint((long)this.input);
        Assertions.assertThat((String)actual).isEqualTo(this.expected);
    }
}

