/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.jar;

import io.camunda.zeebe.util.jar.ExternalJarClassLoader;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalJarRepository
implements AutoCloseable {
    public static final String JAR_EXTENSION = ".jar";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalJarRepository.class);
    private final Map<Path, ExternalJarClassLoader> loadedJars;

    public ExternalJarRepository() {
        this(new HashMap<Path, ExternalJarClassLoader>());
    }

    public ExternalJarRepository(Map<Path, ExternalJarClassLoader> loadedJars) {
        this.loadedJars = loadedJars;
    }

    public Map<Path, ExternalJarClassLoader> getJars() {
        return Collections.unmodifiableMap(this.loadedJars);
    }

    public ExternalJarClassLoader remove(String jarPath) {
        return this.remove(Paths.get(jarPath, new String[0]));
    }

    public ExternalJarClassLoader remove(Path jarPath) {
        return this.loadedJars.remove(jarPath);
    }

    public ExternalJarClassLoader load(String jarPath) throws ExternalJarLoadException {
        return this.load(Paths.get(jarPath, new String[0]));
    }

    public ExternalJarClassLoader load(Path jarPath) throws ExternalJarLoadException {
        ExternalJarClassLoader classLoader = this.loadedJars.get(jarPath);
        if (classLoader == null) {
            this.verifyJarPath(jarPath);
            classLoader = ExternalJarClassLoader.ofPath(jarPath);
            this.loadedJars.put(jarPath, classLoader);
        }
        return classLoader;
    }

    @Override
    public void close() throws Exception {
        this.loadedJars.forEach(this::closeClassLoader);
    }

    private void verifyJarPath(Path path) throws ExternalJarLoadException {
        File jarFile = path.toFile();
        if (!jarFile.getName().endsWith(JAR_EXTENSION)) {
            throw new ExternalJarLoadException(path, "is not a JAR");
        }
        if (!jarFile.canRead()) {
            throw new ExternalJarLoadException(path, "is not readable");
        }
    }

    private void closeClassLoader(Path path, ExternalJarClassLoader classLoader) {
        try {
            classLoader.close(false);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close external JAR class loader for path {}", (Object)path, (Object)e);
        }
    }
}

