/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.jar;

import io.camunda.zeebe.util.jar.ExternalJarClassLoader;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.jar.ExternalJarRepository;
import io.camunda.zeebe.util.jar.ExternalService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import net.bytebuddy.dynamic.DynamicType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExternalJarRepositoryTest {
    private final ExternalJarRepository jarRepository = new ExternalJarRepository();

    ExternalJarRepositoryTest() {
    }

    @Test
    void shouldThrowExceptionOnLoadIfNotAJar(@TempDir Path tempDir) throws IOException {
        Path fake = tempDir.resolve("fake-file");
        Files.writeString(fake, (CharSequence)"foo", new OpenOption[0]);
        Assertions.assertThatThrownBy(() -> this.jarRepository.load(fake)).isInstanceOf(ExternalJarLoadException.class);
    }

    @Test
    void shouldThrowExceptionIfJarMissing(@TempDir Path tempDir) {
        Path dummy = tempDir.resolve("missing.jar");
        Assertions.assertThatThrownBy(() -> this.jarRepository.load(dummy)).isInstanceOf(ExternalJarLoadException.class);
    }

    @Test
    void shouldLoadClassLoaderForJar(@TempDir File tempDir) throws IOException {
        DynamicType.Unloaded<ExternalService.Service> serviceClass = ExternalService.createUnloadedExporterClass();
        File jarFile = serviceClass.toJar(new File(tempDir, "service.jar"));
        Assertions.assertThat((Object)this.jarRepository.load(jarFile.getAbsolutePath())).isInstanceOf(ExternalJarClassLoader.class);
    }

    @Test
    void shouldLoadClassLoaderCorrectlyOnlyOnce(@TempDir File tempDir) throws Exception {
        DynamicType.Unloaded<ExternalService.Service> serviceClass = ExternalService.createUnloadedExporterClass();
        File jarFile = serviceClass.toJar(new File(tempDir, "service.jar"));
        ExternalJarClassLoader classLoader = this.jarRepository.load(jarFile.toPath());
        Assertions.assertThat((Object)this.jarRepository.load(jarFile.toPath())).isEqualTo((Object)classLoader);
    }

    @Test
    void shouldCloseClassLoadersWithExplicitCall() throws Exception {
        HashMap<Path, ExternalJarClassLoader> loadedJars = new HashMap<Path, ExternalJarClassLoader>();
        ExternalJarClassLoader externalJarClassLoaderMock = (ExternalJarClassLoader)Mockito.mock(ExternalJarClassLoader.class);
        loadedJars.put((Path)Mockito.mock(Path.class), externalJarClassLoaderMock);
        ExternalJarRepository repo = new ExternalJarRepository(loadedJars);
        repo.close();
        ((ExternalJarClassLoader)Mockito.verify((Object)externalJarClassLoaderMock)).close(false);
    }

    @Test
    void shouldCloseClassLoadersWithTryWithResources() throws Exception {
        HashMap<Path, ExternalJarClassLoader> loadedJars = new HashMap<Path, ExternalJarClassLoader>();
        ExternalJarClassLoader externalJarClassLoaderMock = (ExternalJarClassLoader)Mockito.mock(ExternalJarClassLoader.class);
        loadedJars.put((Path)Mockito.mock(Path.class), externalJarClassLoaderMock);
        try (ExternalJarRepository repo = new ExternalJarRepository(loadedJars);){
            repo.getJars();
        }
        ((ExternalJarClassLoader)Mockito.verify((Object)externalJarClassLoaderMock)).close(false);
    }
}

