/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.jar;

import io.camunda.zeebe.util.jar.ExternalJarClassLoader;
import io.camunda.zeebe.util.jar.ExternalService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import net.bytebuddy.dynamic.DynamicType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExternalJarClassLoaderTest {
    ExternalJarClassLoaderTest() {
    }

    @Test
    void shouldLoadClassesPackagedInJar(@TempDir File tempDir) throws Exception {
        DynamicType.Unloaded<ExternalService.Service> serviceClass = ExternalService.createUnloadedExporterClass();
        File jarFile = serviceClass.toJar(new File(tempDir, "service.jar"));
        ExternalJarClassLoader classLoader = ExternalJarClassLoader.ofPath((Path)jarFile.toPath());
        Class loadedClass = classLoader.loadClass("com.acme.ExternalService");
        Constructor constructor = loadedClass.getConstructor(new Class[0]);
        Assertions.assertThat((Object)loadedClass.getDeclaredField("FOO").get(loadedClass)).isEqualTo((Object)"bar");
        Assertions.assertThat(constructor.newInstance(new Object[0])).isInstanceOf(ExternalService.Service.class);
    }

    @Test
    void shouldUseSystemClassLoaderAsFallback(@TempDir File tempDir) throws IOException, ClassNotFoundException {
        DynamicType.Unloaded<ExternalService.Service> serviceClass = ExternalService.createUnloadedExporterClass();
        File jarFile = serviceClass.toJar(new File(tempDir, "service.jar"));
        ExternalJarClassLoader classLoader = ExternalJarClassLoader.ofPath((Path)jarFile.toPath());
        Class loadedClass = classLoader.loadClass(Logger.class.getCanonicalName());
        Assertions.assertThat((Class)loadedClass).isEqualTo(Logger.class);
        ((ObjectAssert)Assertions.assertThat((Object)classLoader.getParent()).isEqualTo((Object)this.getClass().getClassLoader())).isEqualTo((Object)ClassLoader.getSystemClassLoader());
    }

    @Test
    void shouldLoadResourceFiles(@TempDir File tempDir) throws Exception {
        String testResourceValue = "test-value";
        String resourceName = "test-resource.txt";
        File jarFile = new File(tempDir, "with-resource.jar");
        try (FileOutputStream fileOutputStream = new FileOutputStream(jarFile);
             JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);){
            jarOutputStream.putNextEntry(new JarEntry("test-resource.txt"));
            jarOutputStream.write("test-value".getBytes(StandardCharsets.UTF_8));
            jarOutputStream.closeEntry();
        }
        ExternalJarClassLoader classLoader = ExternalJarClassLoader.ofPath((Path)jarFile.toPath());
        String storedValue = new String(classLoader.getResourceAsStream("test-resource.txt").readAllBytes());
        Assertions.assertThat((String)storedValue).isEqualTo("test-value");
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(booleans={true, false})
    void shouldCloseWhenInvoked(Boolean param, @TempDir File tempDir) throws IOException {
        DynamicType.Unloaded<ExternalService.Service> serviceClass = ExternalService.createUnloadedExporterClass();
        File jarFile = serviceClass.toJar(new File(tempDir, "service.jar"));
        ExternalJarClassLoader classLoader = ExternalJarClassLoader.ofPath((Path)jarFile.toPath());
        if (param == null) {
            classLoader.close();
        } else {
            classLoader.close(param.booleanValue());
        }
        Assertions.assertThatCode(() -> classLoader.loadClass("com.acme.ExternalService")).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    void shouldCloseWhenTryWithResourcesCompleted(@TempDir File tempDir) throws Exception {
        ExternalJarClassLoader classLoaderRef;
        DynamicType.Unloaded<ExternalService.Service> serviceClass = ExternalService.createUnloadedExporterClass();
        File jarFile = serviceClass.toJar(new File(tempDir, "service.jar"));
        try (ExternalJarClassLoader classLoaderRefInternal = ExternalJarClassLoader.ofPath((Path)jarFile.toPath());){
            classLoaderRef = classLoaderRefInternal;
        }
        Assertions.assertThatCode(() -> ExternalJarClassLoaderTest.lambda$shouldCloseWhenTryWithResourcesCompleted$1((URLClassLoader)classLoaderRef)).isInstanceOf(ClassNotFoundException.class);
    }

    private static /* synthetic */ void lambda$shouldCloseWhenTryWithResourcesCompleted$1(URLClassLoader classLoaderRef) throws Throwable {
        classLoaderRef.loadClass("com.acme.ExternalService");
    }
}

