/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.impl.ProcessingStateMachine;
import io.camunda.zeebe.stream.impl.metrics.StreamMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.EnumMeter;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessingMetrics {
    private static final String ACTION_WRITTEN = "written";
    private static final String ACTION_SKIPPED = "skipped";
    private static final String ACTION_PROCESSED = "processed";
    private final AtomicLong lastProcessedPosition = new AtomicLong();
    private final Table<ValueType, Intent, Timer> processingDuration = Table.simple();
    private final Map<String, Counter> streamProcessorEvents = new HashMap<String, Counter>();
    private final MeterRegistry registry;
    private final Timer batchProcessingDuration;
    private final Timer batchProcessingPostCommitTasks;
    private final DistributionSummary batchProcessingCommands;
    private final Counter batchProcessingRetries;
    private final EnumMeter<ProcessingStateMachine.ErrorHandlingPhase> errorHandlingPhase;
    private final Timer processingLatency;

    public ProcessingMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.registerLastProcessedPosition();
        this.batchProcessingDuration = this.registerTimer(StreamMetricsDoc.BATCH_PROCESSING_DURATION);
        this.batchProcessingPostCommitTasks = this.registerTimer(StreamMetricsDoc.BATCH_PROCESSING_POST_COMMIT_TASKS);
        this.batchProcessingCommands = this.registerBatchProcessingCommands();
        this.batchProcessingRetries = this.registerBatchProcessingRetries();
        this.errorHandlingPhase = EnumMeter.register(ProcessingStateMachine.ErrorHandlingPhase.class, (ExtendedMeterDocumentation)StreamMetricsDoc.ERROR_HANDLING_PHASE, (KeyName)StreamMetricsDoc.ErrorHandlingPhaseKeys.ERROR_HANDLING_PHASE, (MeterRegistry)registry);
        this.processingLatency = this.registerProcessingLatency();
        this.errorHandlingPhase.state((Enum)ProcessingStateMachine.ErrorHandlingPhase.NO_ERROR);
    }

    public CloseableSilently startBatchProcessingDurationTimer() {
        return MicrometerUtil.timer((Timer)this.batchProcessingDuration, (Timer.Sample)Timer.start((Clock)this.registry.config().clock()));
    }

    public void observeCommandCount(int commandCount) {
        this.batchProcessingCommands.record((double)commandCount);
    }

    public void countRetry() {
        this.batchProcessingRetries.increment();
    }

    public CloseableSilently startBatchProcessingPostCommitTasksTimer() {
        return MicrometerUtil.timer((Timer)this.batchProcessingPostCommitTasks, (Timer.Sample)Timer.start((Clock)this.registry.config().clock()));
    }

    public void errorHandlingPhase(ProcessingStateMachine.ErrorHandlingPhase phase) {
        this.errorHandlingPhase.state((Enum)phase);
    }

    public void processingLatency(long written, long processed) {
        this.processingLatency.record(processed - written, TimeUnit.MILLISECONDS);
    }

    public CloseableSilently startProcessingDurationTimer(ValueType valueType, Intent intent) {
        Timer timer = (Timer)this.processingDuration.computeIfAbsent((Object)valueType, (Object)intent, this::registerProcessingDurationTimer);
        return MicrometerUtil.timer((Timer)timer, (Timer.Sample)Timer.start((Clock)this.registry.config().clock()));
    }

    public void commandsProcessed() {
        this.event(ACTION_PROCESSED);
    }

    public void recordsWritten(long amount) {
        if (amount < 1L) {
            return;
        }
        this.countStreamProcessorEvent(ACTION_WRITTEN, amount);
    }

    public void eventSkipped() {
        this.event(ACTION_SKIPPED);
    }

    public void setLastProcessedPosition(long position) {
        this.lastProcessedPosition.set(position);
    }

    private DistributionSummary registerBatchProcessingCommands() {
        StreamMetricsDoc commandsDoc = StreamMetricsDoc.BATCH_PROCESSING_COMMANDS;
        DistributionSummary batchProcessingCommands = DistributionSummary.builder((String)commandsDoc.getName()).description(commandsDoc.getDescription()).serviceLevelObjectives(commandsDoc.getDistributionSLOs()).register(this.registry);
        return batchProcessingCommands;
    }

    private Counter registerBatchProcessingRetries() {
        StreamMetricsDoc retriesDoc = StreamMetricsDoc.BATCH_PROCESSING_RETRIES;
        Counter batchProcessingRetries = Counter.builder((String)retriesDoc.getName()).description(retriesDoc.getDescription()).register(this.registry);
        return batchProcessingRetries;
    }

    private Timer registerTimer(StreamMetricsDoc meterDoc) {
        return Timer.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).serviceLevelObjectives(meterDoc.getTimerSLOs()).register(this.registry);
    }

    private void registerLastProcessedPosition() {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.LAST_PROCESSED_POSITION;
        Gauge.builder((String)meterDoc.getName(), (Object)this.lastProcessedPosition, AtomicLong::longValue).description(meterDoc.getDescription()).register(this.registry);
    }

    private void event(String action) {
        this.countStreamProcessorEvent(action, 1L);
    }

    private void countStreamProcessorEvent(String action, long count) {
        this.streamProcessorEvents.computeIfAbsent(action, this::registerStreamProcessorEventCounter).increment((double)count);
    }

    private Counter registerStreamProcessorEventCounter(String action) {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.STREAM_PROCESSOR_EVENTS;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(StreamMetricsDoc.StreamProcessorActionKeys.ACTION.asString(), action).register(this.registry);
    }

    private Timer registerProcessingLatency() {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.PROCESSING_LATENCY;
        return Timer.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).serviceLevelObjectives(meterDoc.getTimerSLOs()).register(this.registry);
    }

    private Timer registerProcessingDurationTimer(ValueType valueType, Intent intent) {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.PROCESSING_DURATION;
        return Timer.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).serviceLevelObjectives(meterDoc.getTimerSLOs()).tag(StreamMetricsDoc.ProcessingDurationKeys.VALUE_TYPE.asString(), valueType.name()).tag(StreamMetricsDoc.ProcessingDurationKeys.INTENT.asString(), intent.name()).register(this.registry);
    }
}

