/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.SimpleProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import java.time.Duration;

public class ExtendedProcessingScheduleServiceImpl
implements ProcessingScheduleService {
    private final SimpleProcessingScheduleService processorActorService;
    private final SimpleProcessingScheduleService asyncActorService;
    private final ConcurrencyControl concurrencyControl;
    private final boolean alwaysAsync;

    public ExtendedProcessingScheduleServiceImpl(SimpleProcessingScheduleService processorActorService, SimpleProcessingScheduleService asyncActorService, ConcurrencyControl concurrencyControl, boolean alwaysAsync) {
        this.processorActorService = processorActorService;
        this.asyncActorService = asyncActorService;
        this.concurrencyControl = concurrencyControl;
        this.alwaysAsync = alwaysAsync;
    }

    @Override
    public void runAtFixedRateAsync(Duration delay, Task task) {
        this.concurrencyControl.run(() -> this.asyncActorService.runAtFixedRate(delay, task));
    }

    @Override
    public SimpleProcessingScheduleService.ScheduledTask runDelayedAsync(Duration delay, Task task) {
        ActorFuture futureScheduledTask = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            SimpleProcessingScheduleService.ScheduledTask scheduledTask = this.asyncActorService.runDelayed(delay, task);
            futureScheduledTask.complete((Object)scheduledTask);
        });
        return new AsyncScheduledTask((ActorFuture<SimpleProcessingScheduleService.ScheduledTask>)futureScheduledTask);
    }

    @Override
    public SimpleProcessingScheduleService.ScheduledTask runAtAsync(long timestamp, Task task) {
        ActorFuture futureScheduledTask = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            SimpleProcessingScheduleService.ScheduledTask scheduledTask = this.asyncActorService.runAt(timestamp, task);
            futureScheduledTask.complete((Object)scheduledTask);
        });
        return new AsyncScheduledTask((ActorFuture<SimpleProcessingScheduleService.ScheduledTask>)futureScheduledTask);
    }

    @Override
    public SimpleProcessingScheduleService.ScheduledTask runDelayed(Duration delay, Runnable task) {
        if (this.alwaysAsync) {
            ActorFuture futureScheduledTask = this.concurrencyControl.createFuture();
            this.concurrencyControl.run(() -> {
                SimpleProcessingScheduleService.ScheduledTask scheduledTask = this.asyncActorService.runDelayed(delay, task);
                futureScheduledTask.complete((Object)scheduledTask);
            });
            return new AsyncScheduledTask((ActorFuture<SimpleProcessingScheduleService.ScheduledTask>)futureScheduledTask);
        }
        return this.processorActorService.runDelayed(delay, task);
    }

    @Override
    public SimpleProcessingScheduleService.ScheduledTask runDelayed(Duration delay, Task task) {
        if (this.alwaysAsync) {
            return this.runDelayedAsync(delay, task);
        }
        return this.processorActorService.runDelayed(delay, task);
    }

    @Override
    public SimpleProcessingScheduleService.ScheduledTask runAt(long timestamp, Task task) {
        if (this.alwaysAsync) {
            return this.runAtAsync(timestamp, task);
        }
        return this.processorActorService.runAt(timestamp, task);
    }

    @Override
    public SimpleProcessingScheduleService.ScheduledTask runAt(long timestamp, Runnable task) {
        if (this.alwaysAsync) {
            ActorFuture futureScheduledTask = this.concurrencyControl.createFuture();
            this.concurrencyControl.run(() -> {
                SimpleProcessingScheduleService.ScheduledTask scheduledTask = this.asyncActorService.runAt(timestamp, task);
                futureScheduledTask.complete((Object)scheduledTask);
            });
            return new AsyncScheduledTask((ActorFuture<SimpleProcessingScheduleService.ScheduledTask>)futureScheduledTask);
        }
        return this.processorActorService.runAt(timestamp, task);
    }

    @Override
    public void runAtFixedRate(Duration delay, Task task) {
        if (this.alwaysAsync) {
            this.runAtFixedRateAsync(delay, task);
        } else {
            this.processorActorService.runAtFixedRate(delay, task);
        }
    }

    private final class AsyncScheduledTask
    implements SimpleProcessingScheduleService.ScheduledTask {
        private final ActorFuture<SimpleProcessingScheduleService.ScheduledTask> futureScheduledTask;

        public AsyncScheduledTask(ActorFuture<SimpleProcessingScheduleService.ScheduledTask> futureScheduledTask) {
            this.futureScheduledTask = futureScheduledTask;
        }

        @Override
        public void cancel() {
            ExtendedProcessingScheduleServiceImpl.this.concurrencyControl.run(() -> ExtendedProcessingScheduleServiceImpl.this.concurrencyControl.runOnCompletion(this.futureScheduledTask, (scheduledTask, throwable) -> {
                if (scheduledTask != null) {
                    scheduledTask.cancel();
                }
            }));
        }
    }
}

