/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.stream.impl.metrics.StreamMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class StreamProcessorMetrics {
    private final AtomicLong startupRecoveryTime = new AtomicLong();
    private final AtomicInteger processorState = new AtomicInteger();
    private final MeterRegistry registry;

    public StreamProcessorMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.registerStartupRecoveryTime();
        this.registerProcessorState();
    }

    public void setStreamProcessorInitial() {
        this.processorState.set(0);
    }

    public void setStreamProcessorReplay() {
        this.processorState.set(1);
    }

    public void setStreamProcessorProcessing() {
        this.processorState.set(2);
    }

    public void setStreamProcessorFailed() {
        this.processorState.set(3);
    }

    public void setStreamProcessorPaused() {
        this.processorState.set(4);
    }

    public CloseableSilently startRecoveryTimer() {
        return MicrometerUtil.timer(this.startupRecoveryTime::set, (TimeUnit)TimeUnit.MILLISECONDS, (Clock)this.registry.config().clock());
    }

    public void initializeProcessorPhase(StreamProcessor.Phase phase) {
        switch (phase) {
            case INITIAL: {
                this.setStreamProcessorInitial();
                break;
            }
            case REPLAY: {
                this.setStreamProcessorReplay();
                break;
            }
            case PROCESSING: {
                this.setStreamProcessorProcessing();
                break;
            }
            case PAUSED: {
                this.setStreamProcessorPaused();
                break;
            }
            default: {
                this.setStreamProcessorFailed();
            }
        }
    }

    private void registerStartupRecoveryTime() {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.PROCESSOR_STATE;
        TimeGauge.builder((String)meterDoc.getName(), (Object)this.startupRecoveryTime, (TimeUnit)TimeUnit.MILLISECONDS, AtomicLong::longValue).description(meterDoc.getDescription()).register(this.registry);
    }

    private void registerProcessorState() {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.PROCESSOR_STATE;
        Gauge.builder((String)meterDoc.getName(), (Object)this.processorState, AtomicInteger::intValue).description(meterDoc.getDescription()).register(this.registry);
    }
}

