/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.stream.api.StreamClock;
import java.time.Clock;
import java.time.Instant;
import java.time.InstantSource;
import java.time.ZoneId;
import java.util.Objects;

public final class UncontrolledStreamClock
implements StreamClock {
    private final InstantSource source;

    public UncontrolledStreamClock(InstantSource source) {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public StreamClock.ControllableStreamClock.Modification currentModification() {
        return StreamClock.ControllableStreamClock.Modification.none();
    }

    @Override
    public Instant instant() {
        return this.source.instant();
    }

    @Override
    public long millis() {
        return this.source.millis();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this.source.withZone(zone);
    }

    public int hashCode() {
        return Objects.hashCode(this.source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UncontrolledStreamClock)) {
            return false;
        }
        UncontrolledStreamClock that = (UncontrolledStreamClock)o;
        return Objects.equals(this.source, that.source);
    }

    public String toString() {
        return "UncontrolledStreamClock{source=" + String.valueOf(this.source) + "}";
    }
}

