/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.stream.api.EventFilter;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamClock;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.state.KeyGeneratorControls;
import io.camunda.zeebe.stream.api.state.MutableLastProcessedPositionState;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.stream.impl.StreamProcessorListener;
import io.camunda.zeebe.stream.impl.StreamProcessorMode;
import io.camunda.zeebe.stream.impl.records.RecordValues;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public final class StreamProcessorContext
implements ReadonlyStreamProcessorContext {
    public static final int DEFAULT_MAX_COMMANDS_IN_BATCH = 100;
    private static final StreamProcessorListener NOOP_LISTENER = processedCommand -> {};
    private ActorControl actor;
    private LogStream logStream;
    private LogStreamReader logStreamReader;
    private RecordValues recordValues;
    private TransactionContext transactionContext;
    private BooleanSupplier abortCondition;
    private StreamProcessorListener streamProcessorListener = NOOP_LISTENER;
    private StreamProcessorMode streamProcessorMode = StreamProcessorMode.PROCESSING;
    private ProcessingScheduleService processingScheduleService;
    private MutableLastProcessedPositionState lastProcessedPositionState;
    private LogStreamWriter logStreamWriter;
    private CommandResponseWriter commandResponseWriter;
    private InterPartitionCommandSender partitionCommandSender;
    private volatile StreamProcessor.Phase phase = StreamProcessor.Phase.INITIAL;
    private KeyGeneratorControls keyGeneratorControls;
    private int maxCommandsInBatch = 100;
    private boolean enableAsyncScheduledTasks = true;
    private EventFilter processingFilter = e -> true;
    private StreamClock.ControllableStreamClock clock;
    private MeterRegistry meterRegistry;
    private Duration scheduledTaskCheckInterval = Duration.ofSeconds(1L);

    public StreamProcessorContext actor(ActorControl actor) {
        this.actor = actor;
        return this;
    }

    public StreamProcessorContext scheduleService(ProcessingScheduleService scheduleService) {
        this.processingScheduleService = scheduleService;
        return this;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.processingScheduleService;
    }

    @Override
    public int getPartitionId() {
        return this.getLogStream().getPartitionId();
    }

    @Override
    public boolean enableAsyncScheduledTasks() {
        return this.enableAsyncScheduledTasks;
    }

    @Override
    public StreamClock.ControllableStreamClock getClock() {
        return this.clock;
    }

    public StreamProcessorContext clock(StreamClock.ControllableStreamClock clock) {
        this.clock = Objects.requireNonNull(clock);
        return this;
    }

    public LogStream getLogStream() {
        return this.logStream;
    }

    public MutableLastProcessedPositionState getLastProcessedPositionState() {
        return this.lastProcessedPositionState;
    }

    StreamProcessorContext listener(StreamProcessorListener streamProcessorListener) {
        this.streamProcessorListener = streamProcessorListener;
        return this;
    }

    public StreamProcessorContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public StreamProcessorContext logStreamReader(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        return this;
    }

    public StreamProcessorContext eventCache(RecordValues recordValues) {
        this.recordValues = recordValues;
        return this;
    }

    public StreamProcessorContext keyGeneratorControls(KeyGeneratorControls keyGeneratorControls) {
        this.keyGeneratorControls = keyGeneratorControls;
        return this;
    }

    public StreamProcessorContext lastProcessedPositionState(MutableLastProcessedPositionState lastProcessedPositionState) {
        this.lastProcessedPositionState = lastProcessedPositionState;
        return this;
    }

    public StreamProcessorContext transactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        return this;
    }

    public StreamProcessorContext abortCondition(BooleanSupplier abortCondition) {
        this.abortCondition = abortCondition;
        return this;
    }

    public StreamProcessorContext commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.commandResponseWriter = commandResponseWriter;
        return this;
    }

    public StreamProcessorContext processorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorMode = streamProcessorMode;
        return this;
    }

    public KeyGeneratorControls getKeyGeneratorControls() {
        return this.keyGeneratorControls;
    }

    public ActorControl getActor() {
        return this.actor;
    }

    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    public RecordValues getRecordValues() {
        return this.recordValues;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public BooleanSupplier getAbortCondition() {
        return this.abortCondition;
    }

    public StreamProcessorListener getStreamProcessorListener() {
        return this.streamProcessorListener;
    }

    public StreamProcessorMode getProcessorMode() {
        return this.streamProcessorMode;
    }

    public void logStreamWriter(LogStreamWriter writer) {
        this.logStreamWriter = writer;
    }

    public LogStreamWriter getLogStreamWriter() {
        return this.logStreamWriter;
    }

    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriter;
    }

    public InterPartitionCommandSender getPartitionCommandSender() {
        return this.partitionCommandSender;
    }

    public void partitionCommandSender(InterPartitionCommandSender partitionCommandSender) {
        this.partitionCommandSender = partitionCommandSender;
    }

    public StreamProcessor.Phase getStreamProcessorPhase() {
        return this.phase;
    }

    public void streamProcessorPhase(StreamProcessor.Phase phase) {
        this.phase = phase;
    }

    public StreamProcessorContext maxCommandsInBatch(int maxCommandsInBatch) {
        this.maxCommandsInBatch = maxCommandsInBatch;
        return this;
    }

    public int getMaxCommandsInBatch() {
        return this.maxCommandsInBatch;
    }

    public StreamProcessorContext setEnableAsyncScheduledTasks(boolean enabled) {
        this.enableAsyncScheduledTasks = enabled;
        return this;
    }

    public EventFilter processingFilter() {
        return this.processingFilter;
    }

    public StreamProcessorContext processingFilter(EventFilter processingFilter) {
        this.processingFilter = processingFilter;
        return this;
    }

    public StreamProcessorContext meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public Duration getScheduledTaskCheckInterval() {
        return this.scheduledTaskCheckInterval;
    }

    public StreamProcessorContext setScheduledTaskCheckInterval(Duration scheduledTaskCheckInterval) {
        this.scheduledTaskCheckInterval = scheduledTaskCheckInterval;
        return this;
    }
}

