/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.records;

import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.Map;

public class UnwrittenRecord
implements TypedRecord {
    private final long key;
    private final int partitionId;
    private final UnifiedRecordValue value;
    private final RecordMetadata metadata;

    public UnwrittenRecord(long key, int partitionId, UnifiedRecordValue value, RecordMetadata metadata) {
        this.key = key;
        this.partitionId = partitionId;
        this.value = value;
        this.metadata = metadata;
    }

    public long getPosition() {
        throw new UnsupportedOperationException();
    }

    public long getSourceRecordPosition() {
        throw new UnsupportedOperationException();
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    public Intent getIntent() {
        return this.metadata.getIntent();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public RecordType getRecordType() {
        return this.metadata.getRecordType();
    }

    public RejectionType getRejectionType() {
        return this.metadata.getRejectionType();
    }

    public String getRejectionReason() {
        return this.metadata.getRejectionReason();
    }

    public String getBrokerVersion() {
        return this.metadata.getBrokerVersion().toString();
    }

    public Map<String, Object> getAuthorizations() {
        return this.metadata.getAuthorization().toDecodedMap();
    }

    public int getRecordVersion() {
        return this.metadata.getRecordVersion();
    }

    public ValueType getValueType() {
        return this.metadata.getValueType();
    }

    public long getOperationReference() {
        return this.metadata.getOperationReference();
    }

    @Override
    public long getKey() {
        return this.key;
    }

    public UnifiedRecordValue getValue() {
        return this.value;
    }

    @Override
    public int getRequestStreamId() {
        return this.metadata.getRequestStreamId();
    }

    @Override
    public long getRequestId() {
        return this.metadata.getRequestId();
    }

    @Override
    public int getLength() {
        return this.metadata.getLength() + this.value.getLength();
    }
}

