/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.stream.api.EventFilter;
import java.util.Set;
import org.agrona.collections.LongHashSet;

public final class SkipPositionsFilter
implements EventFilter {
    private final LongHashSet positionsToSkip;

    private SkipPositionsFilter(LongHashSet positionsToSkip) {
        this.positionsToSkip = positionsToSkip;
    }

    public static SkipPositionsFilter of(Set<Long> positionsToSkip) {
        LongHashSet longHashSet = new LongHashSet(positionsToSkip.size());
        longHashSet.addAll(positionsToSkip);
        return new SkipPositionsFilter(longHashSet);
    }

    @Override
    public boolean applies(LoggedEvent event) {
        return this.positionsToSkip.isEmpty() || !this.positionsToSkip.contains(event.getPosition());
    }
}

