/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import java.util.Map;
import java.util.Objects;
import org.agrona.DirectBuffer;

public final class VariableDocumentRecord
extends UnifiedRecordValue
implements VariableDocumentRecordValue {
    private final LongProperty scopeKeyProperty = new LongProperty("scopeKey");
    private final EnumProperty<VariableDocumentUpdateSemantic> updateSemanticsProperty = new EnumProperty("updateSemantics", VariableDocumentUpdateSemantic.class, (Enum)VariableDocumentUpdateSemantic.PROPAGATE);
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");

    public VariableDocumentRecord() {
        super(3);
        this.declareProperty((BaseProperty)this.scopeKeyProperty).declareProperty(this.updateSemanticsProperty).declareProperty((BaseProperty)this.variablesProperty);
    }

    public VariableDocumentRecord wrap(VariableDocumentRecord other) {
        this.setScopeKey(other.getScopeKey()).setVariables(other.getVariablesBuffer()).setUpdateSemantics(other.getUpdateSemantics());
        return this;
    }

    public long getScopeKey() {
        return this.scopeKeyProperty.getValue();
    }

    public VariableDocumentRecord setScopeKey(long scopeKey) {
        this.scopeKeyProperty.setValue(scopeKey);
        return this;
    }

    public VariableDocumentUpdateSemantic getUpdateSemantics() {
        return (VariableDocumentUpdateSemantic)this.updateSemanticsProperty.getValue();
    }

    public VariableDocumentRecord setUpdateSemantics(VariableDocumentUpdateSemantic updateSemantics) {
        this.updateSemanticsProperty.setValue((Enum)updateSemantics);
        return this;
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    public VariableDocumentRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.scopeKeyProperty, this.updateSemanticsProperty, this.variablesProperty);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableDocumentRecord)) {
            return false;
        }
        VariableDocumentRecord that = (VariableDocumentRecord)((Object)o);
        return Objects.equals(this.scopeKeyProperty, that.scopeKeyProperty) && Objects.equals(this.updateSemanticsProperty, that.updateSemanticsProperty) && Objects.equals(this.variablesProperty, that.variablesProperty);
    }

    public String getTenantId() {
        return "<default>";
    }
}

