/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.extension;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.process.test.ObjectMapperConfig;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.engine.EngineFactory;
import io.camunda.zeebe.process.test.filters.RecordStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeProcessTestExtension
implements BeforeEachCallback,
AfterEachCallback,
TestWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeProcessTestExtension.class);
    private static final String KEY_ZEEBE_CLIENT = "ZEEBE_CLIENT";
    private static final String KEY_ZEEBE_ENGINE = "ZEEBE_ENGINE";

    public void beforeEach(ExtensionContext extensionContext) {
        ZeebeTestEngine engine = EngineFactory.create();
        engine.start();
        ObjectMapper objectMapper = this.getObjectMapper(extensionContext);
        ObjectMapperConfig.initObjectMapper((ObjectMapper)objectMapper);
        ZeebeClient client = engine.createClient(objectMapper);
        RecordStream recordStream = RecordStream.of((RecordStreamSource)engine.getRecordStreamSource());
        try {
            this.injectFields(extensionContext, engine, client, recordStream);
        }
        catch (Exception ex) {
            client.close();
            engine.stop();
            throw ex;
        }
        BpmnAssert.initRecordStream((RecordStream)recordStream);
        this.getStore(extensionContext).put((Object)KEY_ZEEBE_CLIENT, (Object)client);
        this.getStore(extensionContext).put((Object)KEY_ZEEBE_ENGINE, (Object)engine);
    }

    public void afterEach(ExtensionContext extensionContext) {
        BpmnAssert.resetRecordStream();
        Object clientContent = this.getStore(extensionContext).get((Object)KEY_ZEEBE_CLIENT);
        ZeebeClient client = (ZeebeClient)clientContent;
        client.close();
        Object engineContent = this.getStore(extensionContext).get((Object)KEY_ZEEBE_ENGINE);
        ZeebeTestEngine engine = (ZeebeTestEngine)engineContent;
        engine.stop();
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        Object engineContent = this.getStore(extensionContext).get((Object)KEY_ZEEBE_ENGINE);
        ZeebeTestEngine engine = (ZeebeTestEngine)engineContent;
        LOG.error("===== Test failed!");
        RecordStream.of((RecordStreamSource)engine.getRecordStreamSource()).print(true);
    }

    private void injectFields(ExtensionContext extensionContext, Object ... objects) {
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        for (Object object : objects) {
            Optional<Field> field = this.getField(requiredTestClass, object.getClass());
            field.ifPresent(value -> this.injectField(extensionContext, (Field)value, object));
        }
    }

    private Optional<Field> getField(Class<?> requiredTestClass, Class<?> clazz) {
        Field[] declaredFields = requiredTestClass.getDeclaredFields();
        List<Field> fields = Arrays.stream(declaredFields).filter(field -> field.getType().isAssignableFrom(clazz)).toList();
        if (fields.size() > 1) {
            throw new IllegalStateException(String.format("Expected at most one field of type %s, but found %s. Please make sure at most one field of type %s has been declared in the test class.", clazz.getSimpleName(), fields.size(), clazz.getSimpleName()));
        }
        if (fields.size() == 0) {
            Class<?> superclass = requiredTestClass.getSuperclass();
            return superclass == null ? Optional.empty() : this.getField(superclass, clazz);
        }
        return Optional.of(fields.get(0));
    }

    private void injectField(ExtensionContext extensionContext, Field field, Object object) {
        try {
            ReflectionUtils.makeAccessible((AccessibleObject)field);
            field.set(extensionContext.getRequiredTestInstance(), object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getUniqueId()}));
    }

    private ObjectMapper getObjectMapper(ExtensionContext context) {
        Optional<Field> customMapperOpt = this.getField(context.getRequiredTestClass(), ObjectMapper.class);
        if (customMapperOpt.isEmpty()) {
            return new ObjectMapper();
        }
        Field customMapper = customMapperOpt.get();
        ReflectionUtils.makeAccessible((AccessibleObject)customMapper);
        try {
            return (ObjectMapper)customMapper.get(context.getRequiredTestInstance());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

