/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.inspections;

import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.model.xml.instance.DomElement;

public class ProcessDefinitionInspectionUtility {
    public static String getBpmnElementId(String bpmnElementName) {
        return ProcessDefinitionInspectionUtility.getBpmnElementId(StreamFilter.processRecords((RecordStream)BpmnAssert.getRecordStream()).getProcessDefinitions(), bpmnElementName);
    }

    public static String getBpmnElementId(String bpmnProcessId, String bpmnElementName) {
        return ProcessDefinitionInspectionUtility.getBpmnElementId(StreamFilter.processRecords((RecordStream)BpmnAssert.getRecordStream()).withBpmnProcessId(bpmnProcessId).getProcessDefinitions(), bpmnElementName);
    }

    public static String getBpmnElementId(DeploymentEvent deployment, String bpmnElementName) {
        return ProcessDefinitionInspectionUtility.getBpmnElementId(StreamFilter.processRecords((RecordStream)BpmnAssert.getRecordStream()).withDeployment(deployment).getProcessDefinitions(), bpmnElementName);
    }

    private static String getBpmnElementId(Stream<Process> stream, String bpmnElementName) {
        List potentialElementIds = stream.map(processResource -> Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(processResource.getResource()))).flatMap(bpmnModelInstance -> ProcessDefinitionInspectionUtility.getChildElementsFlattened(bpmnModelInstance.getDocument().getRootElement()).stream()).filter(element -> Objects.equals(element.getAttribute("name"), bpmnElementName)).map(element -> element.getAttribute("id")).distinct().collect(Collectors.toList());
        Assertions.assertThat(potentialElementIds).hasSize(1);
        return (String)potentialElementIds.get(0);
    }

    private static Set<DomElement> getChildElementsFlattened(DomElement parent) {
        HashSet<DomElement> elements = new HashSet<DomElement>();
        elements.add(parent);
        parent.getChildElements().forEach(child -> elements.addAll(ProcessDefinitionInspectionUtility.getChildElementsFlattened(child)));
        return elements;
    }
}

