/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.bean;

import io.camunda.zeebe.spring.client.bean.BeanInfo;
import io.camunda.zeebe.spring.client.bean.MethodInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public final class ClassInfo
implements BeanInfo {
    private final Object bean;
    private final String beanName;

    private ClassInfo(Object bean, String beanName) {
        this.bean = bean;
        this.beanName = beanName;
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public String toString() {
        return "ClassInfo{beanName=" + this.beanName + "}";
    }

    public MethodInfo toMethodInfo(Method method) {
        return MethodInfo.builder().classInfo(this).method(method).build();
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.getTargetClass(), type));
    }

    public static final ClassInfoBuilder builder() {
        return new ClassInfoBuilder();
    }

    public static final class ClassInfoBuilder {
        private Object bean;
        private String beanName;

        public ClassInfoBuilder bean(Object bean) {
            this.bean = bean;
            return this;
        }

        public ClassInfoBuilder beanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        public ClassInfo build() {
            return new ClassInfo(this.bean, this.beanName);
        }
    }
}

