/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.BrokerInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"brokers", "clusterId", "clusterSize", "partitionsCount", "replicationFactor", "gatewayVersion", "lastCompletedChangeId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TopologyResponse {
    public static final String JSON_PROPERTY_BROKERS = "brokers";
    @Nonnull
    private List<BrokerInfo> brokers = new ArrayList<BrokerInfo>();
    public static final String JSON_PROPERTY_CLUSTER_ID = "clusterId";
    @Nullable
    private String clusterId;
    public static final String JSON_PROPERTY_CLUSTER_SIZE = "clusterSize";
    @Nonnull
    private Integer clusterSize;
    public static final String JSON_PROPERTY_PARTITIONS_COUNT = "partitionsCount";
    @Nonnull
    private Integer partitionsCount;
    public static final String JSON_PROPERTY_REPLICATION_FACTOR = "replicationFactor";
    @Nonnull
    private Integer replicationFactor;
    public static final String JSON_PROPERTY_GATEWAY_VERSION = "gatewayVersion";
    @Nonnull
    private String gatewayVersion;
    public static final String JSON_PROPERTY_LAST_COMPLETED_CHANGE_ID = "lastCompletedChangeId";
    @Nonnull
    private String lastCompletedChangeId;

    public TopologyResponse brokers(@Nonnull List<BrokerInfo> brokers) {
        this.brokers = brokers;
        return this;
    }

    public TopologyResponse addBrokersItem(BrokerInfo brokersItem) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<BrokerInfo>();
        }
        this.brokers.add(brokersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="brokers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BrokerInfo> getBrokers() {
        return this.brokers;
    }

    @JsonProperty(value="brokers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBrokers(@Nonnull List<BrokerInfo> brokers) {
        this.brokers = brokers;
    }

    public TopologyResponse clusterId(@Nullable String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Nullable
    @JsonProperty(value="clusterId", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty(value="clusterId", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClusterId(@Nullable String clusterId) {
        this.clusterId = clusterId;
    }

    public TopologyResponse clusterSize(@Nonnull Integer clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    @Nonnull
    @JsonProperty(value="clusterSize", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getClusterSize() {
        return this.clusterSize;
    }

    @JsonProperty(value="clusterSize", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClusterSize(@Nonnull Integer clusterSize) {
        this.clusterSize = clusterSize;
    }

    public TopologyResponse partitionsCount(@Nonnull Integer partitionsCount) {
        this.partitionsCount = partitionsCount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="partitionsCount", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPartitionsCount() {
        return this.partitionsCount;
    }

    @JsonProperty(value="partitionsCount", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPartitionsCount(@Nonnull Integer partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    public TopologyResponse replicationFactor(@Nonnull Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    @Nonnull
    @JsonProperty(value="replicationFactor", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    @JsonProperty(value="replicationFactor", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReplicationFactor(@Nonnull Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public TopologyResponse gatewayVersion(@Nonnull String gatewayVersion) {
        this.gatewayVersion = gatewayVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="gatewayVersion", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGatewayVersion() {
        return this.gatewayVersion;
    }

    @JsonProperty(value="gatewayVersion", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGatewayVersion(@Nonnull String gatewayVersion) {
        this.gatewayVersion = gatewayVersion;
    }

    public TopologyResponse lastCompletedChangeId(@Nonnull String lastCompletedChangeId) {
        this.lastCompletedChangeId = lastCompletedChangeId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="lastCompletedChangeId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastCompletedChangeId() {
        return this.lastCompletedChangeId;
    }

    @JsonProperty(value="lastCompletedChangeId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastCompletedChangeId(@Nonnull String lastCompletedChangeId) {
        this.lastCompletedChangeId = lastCompletedChangeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyResponse topologyResponse = (TopologyResponse)o;
        return Objects.equals(this.brokers, topologyResponse.brokers) && Objects.equals(this.clusterId, topologyResponse.clusterId) && Objects.equals(this.clusterSize, topologyResponse.clusterSize) && Objects.equals(this.partitionsCount, topologyResponse.partitionsCount) && Objects.equals(this.replicationFactor, topologyResponse.replicationFactor) && Objects.equals(this.gatewayVersion, topologyResponse.gatewayVersion) && Objects.equals(this.lastCompletedChangeId, topologyResponse.lastCompletedChangeId);
    }

    public int hashCode() {
        return Objects.hash(this.brokers, this.clusterId, this.clusterSize, this.partitionsCount, this.replicationFactor, this.gatewayVersion, this.lastCompletedChangeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyResponse {\n");
        sb.append("    brokers: ").append(this.toIndentedString(this.brokers)).append("\n");
        sb.append("    clusterId: ").append(this.toIndentedString(this.clusterId)).append("\n");
        sb.append("    clusterSize: ").append(this.toIndentedString(this.clusterSize)).append("\n");
        sb.append("    partitionsCount: ").append(this.toIndentedString(this.partitionsCount)).append("\n");
        sb.append("    replicationFactor: ").append(this.toIndentedString(this.replicationFactor)).append("\n");
        sb.append("    gatewayVersion: ").append(this.toIndentedString(this.gatewayVersion)).append("\n");
        sb.append("    lastCompletedChangeId: ").append(this.toIndentedString(this.lastCompletedChangeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

