/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"variables", "local", "operationReference"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SetVariableRequest {
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    @Nonnull
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_LOCAL = "local";
    @Nullable
    private Boolean local = false;
    public static final String JSON_PROPERTY_OPERATION_REFERENCE = "operationReference";
    @Nullable
    private Long operationReference;

    public SetVariableRequest variables(@Nonnull Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public SetVariableRequest putVariablesItem(String key, Object variablesItem) {
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="variables", required=true)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables", required=true)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public void setVariables(@Nonnull Map<String, Object> variables) {
        this.variables = variables;
    }

    public SetVariableRequest local(@Nullable Boolean local) {
        this.local = local;
        return this;
    }

    @Nullable
    @JsonProperty(value="local", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLocal() {
        return this.local;
    }

    @JsonProperty(value="local", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocal(@Nullable Boolean local) {
        this.local = local;
    }

    public SetVariableRequest operationReference(@Nullable Long operationReference) {
        this.operationReference = operationReference;
        return this;
    }

    @Nullable
    @JsonProperty(value="operationReference", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOperationReference() {
        return this.operationReference;
    }

    @JsonProperty(value="operationReference", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationReference(@Nullable Long operationReference) {
        this.operationReference = operationReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetVariableRequest setVariableRequest = (SetVariableRequest)o;
        return Objects.equals(this.variables, setVariableRequest.variables) && Objects.equals(this.local, setVariableRequest.local) && Objects.equals(this.operationReference, setVariableRequest.operationReference);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.local, this.operationReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetVariableRequest {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    local: ").append(this.toIndentedString(this.local)).append("\n");
        sb.append("    operationReference: ").append(this.toIndentedString(this.operationReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

