/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"partitionId", "role", "health"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Partition {
    public static final String JSON_PROPERTY_PARTITION_ID = "partitionId";
    @Nonnull
    private Integer partitionId;
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nonnull
    private RoleEnum role;
    public static final String JSON_PROPERTY_HEALTH = "health";
    @Nonnull
    private HealthEnum health;

    public Partition partitionId(@Nonnull Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="partitionId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty(value="partitionId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPartitionId(@Nonnull Integer partitionId) {
        this.partitionId = partitionId;
    }

    public Partition role(@Nonnull RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @JsonProperty(value="role", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="role", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(@Nonnull RoleEnum role) {
        this.role = role;
    }

    public Partition health(@Nonnull HealthEnum health) {
        this.health = health;
        return this;
    }

    @Nonnull
    @JsonProperty(value="health", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HealthEnum getHealth() {
        return this.health;
    }

    @JsonProperty(value="health", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHealth(@Nonnull HealthEnum health) {
        this.health = health;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.partitionId, partition.partitionId) && Objects.equals((Object)this.role, (Object)partition.role) && Objects.equals((Object)this.health, (Object)partition.health);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionId, this.role, this.health});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Partition {\n");
        sb.append("    partitionId: ").append(this.toIndentedString(this.partitionId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    health: ").append(this.toIndentedString((Object)this.health)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        LEADER(String.valueOf("leader")),
        FOLLOWER(String.valueOf("follower")),
        INACTIVE(String.valueOf("inactive")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum HealthEnum {
        HEALTHY(String.valueOf("healthy")),
        UNHEALTHY(String.valueOf("unhealthy")),
        DEAD(String.valueOf("dead")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private HealthEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HealthEnum fromValue(String value) {
            for (HealthEnum b : HealthEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

