/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "correlationKey", "variables", "tenantId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageCorrelationRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CORRELATION_KEY = "correlationKey";
    @Nullable
    private String correlationKey = "";
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    @Nullable
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    @Nullable
    private String tenantId;

    public MessageCorrelationRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public MessageCorrelationRequest correlationKey(@Nullable String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="correlationKey", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @JsonProperty(value="correlationKey", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCorrelationKey(@Nullable String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public MessageCorrelationRequest variables(@Nullable Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public MessageCorrelationRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables", required=false)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables", required=false)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(@Nullable Map<String, Object> variables) {
        this.variables = variables;
    }

    public MessageCorrelationRequest tenantId(@Nullable String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(@Nullable String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCorrelationRequest messageCorrelationRequest = (MessageCorrelationRequest)o;
        return Objects.equals(this.name, messageCorrelationRequest.name) && Objects.equals(this.correlationKey, messageCorrelationRequest.correlationKey) && Objects.equals(this.variables, messageCorrelationRequest.variables) && Objects.equals(this.tenantId, messageCorrelationRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.correlationKey, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageCorrelationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    correlationKey: ").append(this.toIndentedString(this.correlationKey)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

