/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"errorCode", "errorMessage", "variables"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobErrorRequest {
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    @Nonnull
    private String errorCode;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    @Nullable
    private String errorMessage;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    @Nullable
    private Map<String, Object> variables;

    public JobErrorRequest errorCode(@Nonnull String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="errorCode", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorCode(@Nonnull String errorCode) {
        this.errorCode = errorCode;
    }

    public JobErrorRequest errorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="errorMessage", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JobErrorRequest variables(@Nullable Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public JobErrorRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables", required=false)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables", required=false)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(@Nullable Map<String, Object> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobErrorRequest jobErrorRequest = (JobErrorRequest)o;
        return Objects.equals(this.errorCode, jobErrorRequest.errorCode) && Objects.equals(this.errorMessage, jobErrorRequest.errorMessage) && Objects.equals(this.variables, jobErrorRequest.variables);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobErrorRequest {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

