/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"processDefinitionId", "processDefinitionVersion", "tenantId", "variables", "processDefinitionKey", "processInstanceKey", "tags"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateProcessInstanceResult {
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    @Nonnull
    private String processDefinitionId;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
    @Nonnull
    private Integer processDefinitionVersion;
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    @Nonnull
    private String tenantId;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    @Nonnull
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @Nonnull
    private String processDefinitionKey;
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
    @Nonnull
    private String processInstanceKey;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private Set<String> tags = new LinkedHashSet<String>();

    public CreateProcessInstanceResult processDefinitionId(@Nonnull String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="processDefinitionId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @JsonProperty(value="processDefinitionId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProcessDefinitionId(@Nonnull String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public CreateProcessInstanceResult processDefinitionVersion(@Nonnull Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="processDefinitionVersion", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @JsonProperty(value="processDefinitionVersion", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProcessDefinitionVersion(@Nonnull Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public CreateProcessInstanceResult tenantId(@Nonnull String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tenantId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTenantId(@Nonnull String tenantId) {
        this.tenantId = tenantId;
    }

    public CreateProcessInstanceResult variables(@Nonnull Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public CreateProcessInstanceResult putVariablesItem(String key, Object variablesItem) {
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="variables", required=true)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables", required=true)
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public void setVariables(@Nonnull Map<String, Object> variables) {
        this.variables = variables;
    }

    public CreateProcessInstanceResult processDefinitionKey(@Nonnull String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="processDefinitionKey", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="processDefinitionKey", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProcessDefinitionKey(@Nonnull String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public CreateProcessInstanceResult processInstanceKey(@Nonnull String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="processInstanceKey", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="processInstanceKey", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProcessInstanceKey(@Nonnull String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public CreateProcessInstanceResult tags(@Nullable Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateProcessInstanceResult addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new LinkedHashSet<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getTags() {
        return this.tags;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="tags", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable Set<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateProcessInstanceResult createProcessInstanceResult = (CreateProcessInstanceResult)o;
        return Objects.equals(this.processDefinitionId, createProcessInstanceResult.processDefinitionId) && Objects.equals(this.processDefinitionVersion, createProcessInstanceResult.processDefinitionVersion) && Objects.equals(this.tenantId, createProcessInstanceResult.tenantId) && Objects.equals(this.variables, createProcessInstanceResult.variables) && Objects.equals(this.processDefinitionKey, createProcessInstanceResult.processDefinitionKey) && Objects.equals(this.processInstanceKey, createProcessInstanceResult.processInstanceKey) && Objects.equals(this.tags, createProcessInstanceResult.tags);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionId, this.processDefinitionVersion, this.tenantId, this.variables, this.processDefinitionKey, this.processInstanceKey, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateProcessInstanceResult {\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

