/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.TenantResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"username", "displayName", "email", "authorizedComponents", "tenants", "groups", "roles", "salesPlanType", "c8Links", "canLogout"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CamundaUserResult {
    public static final String JSON_PROPERTY_USERNAME = "username";
    @Nullable
    private String username;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nullable
    private String displayName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nullable
    private String email;
    public static final String JSON_PROPERTY_AUTHORIZED_COMPONENTS = "authorizedComponents";
    @Nullable
    private List<String> authorizedComponents = new ArrayList<String>();
    public static final String JSON_PROPERTY_TENANTS = "tenants";
    @Nonnull
    private List<TenantResult> tenants = new ArrayList<TenantResult>();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    @Nonnull
    private List<String> groups = new ArrayList<String>();
    public static final String JSON_PROPERTY_ROLES = "roles";
    @Nonnull
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_SALES_PLAN_TYPE = "salesPlanType";
    @Nonnull
    private String salesPlanType;
    public static final String JSON_PROPERTY_C8_LINKS = "c8Links";
    @Nonnull
    private Map<String, String> c8Links = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CAN_LOGOUT = "canLogout";
    @Nonnull
    private Boolean canLogout;

    public CamundaUserResult username(@Nullable String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public CamundaUserResult displayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public CamundaUserResult email(@Nullable String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public CamundaUserResult authorizedComponents(@Nullable List<String> authorizedComponents) {
        this.authorizedComponents = authorizedComponents;
        return this;
    }

    public CamundaUserResult addAuthorizedComponentsItem(String authorizedComponentsItem) {
        if (this.authorizedComponents == null) {
            this.authorizedComponents = new ArrayList<String>();
        }
        this.authorizedComponents.add(authorizedComponentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="authorizedComponents", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAuthorizedComponents() {
        return this.authorizedComponents;
    }

    @JsonProperty(value="authorizedComponents", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizedComponents(@Nullable List<String> authorizedComponents) {
        this.authorizedComponents = authorizedComponents;
    }

    public CamundaUserResult tenants(@Nonnull List<TenantResult> tenants) {
        this.tenants = tenants;
        return this;
    }

    public CamundaUserResult addTenantsItem(TenantResult tenantsItem) {
        if (this.tenants == null) {
            this.tenants = new ArrayList<TenantResult>();
        }
        this.tenants.add(tenantsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="tenants", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TenantResult> getTenants() {
        return this.tenants;
    }

    @JsonProperty(value="tenants", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTenants(@Nonnull List<TenantResult> tenants) {
        this.tenants = tenants;
    }

    public CamundaUserResult groups(@Nonnull List<String> groups) {
        this.groups = groups;
        return this;
    }

    public CamundaUserResult addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="groups", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroups(@Nonnull List<String> groups) {
        this.groups = groups;
    }

    public CamundaUserResult roles(@Nonnull List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CamundaUserResult addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="roles", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoles(@Nonnull List<String> roles) {
        this.roles = roles;
    }

    public CamundaUserResult salesPlanType(@Nonnull String salesPlanType) {
        this.salesPlanType = salesPlanType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="salesPlanType", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSalesPlanType() {
        return this.salesPlanType;
    }

    @JsonProperty(value="salesPlanType", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSalesPlanType(@Nonnull String salesPlanType) {
        this.salesPlanType = salesPlanType;
    }

    public CamundaUserResult c8Links(@Nonnull Map<String, String> c8Links) {
        this.c8Links = c8Links;
        return this;
    }

    public CamundaUserResult putC8LinksItem(String key, String c8LinksItem) {
        this.c8Links.put(key, c8LinksItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="c8Links", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, String> getC8Links() {
        return this.c8Links;
    }

    @JsonProperty(value="c8Links", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setC8Links(@Nonnull Map<String, String> c8Links) {
        this.c8Links = c8Links;
    }

    public CamundaUserResult canLogout(@Nonnull Boolean canLogout) {
        this.canLogout = canLogout;
        return this;
    }

    @Nonnull
    @JsonProperty(value="canLogout", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCanLogout() {
        return this.canLogout;
    }

    @JsonProperty(value="canLogout", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCanLogout(@Nonnull Boolean canLogout) {
        this.canLogout = canLogout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamundaUserResult camundaUserResult = (CamundaUserResult)o;
        return Objects.equals(this.username, camundaUserResult.username) && Objects.equals(this.displayName, camundaUserResult.displayName) && Objects.equals(this.email, camundaUserResult.email) && Objects.equals(this.authorizedComponents, camundaUserResult.authorizedComponents) && Objects.equals(this.tenants, camundaUserResult.tenants) && Objects.equals(this.groups, camundaUserResult.groups) && Objects.equals(this.roles, camundaUserResult.roles) && Objects.equals(this.salesPlanType, camundaUserResult.salesPlanType) && Objects.equals(this.c8Links, camundaUserResult.c8Links) && Objects.equals(this.canLogout, camundaUserResult.canLogout);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.displayName, this.email, this.authorizedComponents, this.tenants, this.groups, this.roles, this.salesPlanType, this.c8Links, this.canLogout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CamundaUserResult {\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    authorizedComponents: ").append(this.toIndentedString(this.authorizedComponents)).append("\n");
        sb.append("    tenants: ").append(this.toIndentedString(this.tenants)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    salesPlanType: ").append(this.toIndentedString(this.salesPlanType)).append("\n");
        sb.append("    c8Links: ").append(this.toIndentedString(this.c8Links)).append("\n");
        sb.append("    canLogout: ").append(this.toIndentedString(this.canLogout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

