/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.impl.http.ApiCallback;
import io.camunda.zeebe.client.impl.http.ApiEntityConsumer;
import io.camunda.zeebe.client.impl.http.ApiResponseConsumer;
import io.camunda.zeebe.client.impl.http.DocumentDataConsumer;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.http.JsonResponseTransformer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final AtomicBoolean DEPRECATION_WARNING_LOGGED = new AtomicBoolean(false);
    private static final int MAX_RETRY_ATTEMPTS = 2;
    private final CloseableHttpAsyncClient client;
    private final ObjectMapper jsonMapper;
    private final URI address;
    private final RequestConfig defaultRequestConfig;
    private final int maxMessageSize;
    private final TimeValue shutdownTimeout;
    private final CredentialsProvider credentialsProvider;

    public HttpClient(CloseableHttpAsyncClient client, ObjectMapper jsonMapper, URI address, RequestConfig defaultRequestConfig, int maxMessageSize, TimeValue shutdownTimeout, CredentialsProvider credentialsProvider) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.address = address;
        this.defaultRequestConfig = defaultRequestConfig;
        this.maxMessageSize = maxMessageSize;
        this.shutdownTimeout = shutdownTimeout;
        this.credentialsProvider = credentialsProvider;
    }

    public void start() {
        this.client.start();
    }

    @Override
    public void close() throws Exception {
        this.client.close(CloseMode.GRACEFUL);
        try {
            this.client.awaitShutdown(this.shutdownTimeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Expected to await HTTP client shutdown, but was interrupted; client may not be completely shut down", (Throwable)e);
        }
    }

    public RequestConfig.Builder newRequestConfig() {
        return RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
    }

    public <HttpT, RespT> void get(String path, Map<String, String> queryParams, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.GET, path, queryParams, null, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void get(String path, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.GET, path, null, requestConfig, responseType, transformer, result);
    }

    public <RespT> void post(String path, String body, RequestConfig requestConfig, HttpZeebeFuture<RespT> result) {
        this.post(path, body, requestConfig, Void.class, r -> null, result);
    }

    public <HttpT, RespT> void post(String path, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.POST, path, body, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void post(String path, Map<String, String> queryParams, String body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.POST, path, queryParams, body, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void postMultipart(String path, Map<String, String> queryParams, MultipartEntityBuilder multipartBuilder, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        HttpEntity entity = multipartBuilder.build();
        this.sendRequest(Method.POST, path, queryParams, entity, requestConfig, responseType, transformer, result);
    }

    public <HttpT, RespT> void postMultipart(String path, MultipartEntityBuilder multipartBuilder, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        HttpEntity entity = multipartBuilder.build();
        this.sendRequest(Method.POST, path, entity, requestConfig, responseType, transformer, result);
    }

    public <RespT> void put(String path, String body, RequestConfig requestConfig, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.PUT, path, body, requestConfig, Void.class, r -> null, result);
    }

    public <RespT> void patch(String path, String body, RequestConfig requestConfig, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.PATCH, path, body, requestConfig, Void.class, r -> null, result);
    }

    public <RespT> void delete(String path, RequestConfig requestConfig, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.DELETE, path, null, requestConfig, Void.class, r -> null, result);
    }

    public <RespT> void delete(String path, Map<String, String> queryParams, RequestConfig requestConfig, HttpZeebeFuture<RespT> result) {
        this.sendRequest(Method.DELETE, path, queryParams, null, requestConfig, Void.class, r -> null, result);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, Object body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(httpMethod, path, null, body, requestConfig, responseType, transformer, result);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, Map<String, String> queryParams, Object body, RequestConfig requestConfig, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result) {
        this.sendRequest(httpMethod, path, queryParams, body, requestConfig, 2, responseType, transformer, result, null);
    }

    private <HttpT, RespT> void sendRequest(Method httpMethod, String path, Map<String, String> queryParams, Object body, RequestConfig requestConfig, int maxRetries, Class<HttpT> responseType, JsonResponseTransformer<HttpT, RespT> transformer, HttpZeebeFuture<RespT> result, ApiCallback<HttpT, RespT> callback) {
        AtomicReference apiCallback = new AtomicReference(callback);
        if (DEPRECATION_WARNING_LOGGED.compareAndSet(false, true)) {
            LOGGER.warn("{} is deprecated and will be removed in version 8.10. Please migrate to io.camunda.client.CamundaClient.", (Object)ZeebeClient.class.getSimpleName());
        }
        URI target = this.buildRequestURI(path);
        Runnable retryAction = () -> {
            if (result.isCancelled()) {
                return;
            }
            this.sendRequest(httpMethod, path, queryParams, body, requestConfig, maxRetries, responseType, transformer, result, (ApiCallback)apiCallback.get());
        };
        SimpleRequestBuilder requestBuilder = SimpleRequestBuilder.create((Method)httpMethod).setUri(target);
        if (queryParams != null && !queryParams.isEmpty()) {
            queryParams.forEach((arg_0, arg_1) -> ((SimpleRequestBuilder)requestBuilder).addParameter(arg_0, arg_1));
        }
        if (body != null) {
            if (body instanceof String) {
                requestBuilder.setBody((String)body, ContentType.APPLICATION_JSON);
            } else if (body instanceof HttpEntity) {
                byte[] entityBytes;
                HttpEntity entity = (HttpEntity)body;
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    entity.writeTo((OutputStream)byteArrayOutputStream);
                    entityBytes = byteArrayOutputStream.toByteArray();
                }
                catch (IOException e) {
                    result.completeExceptionally(new ClientException("Failed to convert multipart entity to bytes", e));
                    return;
                }
                ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
                requestBuilder.setBody(entityBytes, contentType);
            } else {
                result.completeExceptionally(new ClientException("Unsupported body type: " + body.getClass().getName()));
                return;
            }
        }
        try {
            this.credentialsProvider.applyCredentials((arg_0, arg_1) -> ((SimpleRequestBuilder)requestBuilder).addHeader(arg_0, arg_1));
        }
        catch (IOException e) {
            result.completeExceptionally(new ClientException("Failed to apply credentials to request", e));
            return;
        }
        SimpleHttpRequest request = requestBuilder.build();
        request.setConfig(requestConfig);
        Object entityConsumer = responseType == InputStream.class ? new DocumentDataConsumer(this.maxMessageSize, this.jsonMapper) : new ApiEntityConsumer<HttpT>(this.jsonMapper, responseType, this.maxMessageSize);
        if (apiCallback.get() == null) {
            apiCallback.set(new ApiCallback<HttpT, RespT>(result, transformer, this.credentialsProvider::shouldRetryRequest, retryAction, maxRetries));
        }
        result.transportFuture(this.client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), new ApiResponseConsumer(entityConsumer), (FutureCallback)apiCallback.get()));
    }

    private URI buildRequestURI(String path) {
        URI target;
        try {
            target = new URIBuilder(this.address).appendPath(path).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return target;
    }
}

