/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Contains properties of a user task. */
@JsonPropertyOrder({
  UserTaskProperties.JSON_PROPERTY_ACTION,
  UserTaskProperties.JSON_PROPERTY_ASSIGNEE,
  UserTaskProperties.JSON_PROPERTY_CANDIDATE_GROUPS,
  UserTaskProperties.JSON_PROPERTY_CANDIDATE_USERS,
  UserTaskProperties.JSON_PROPERTY_CHANGED_ATTRIBUTES,
  UserTaskProperties.JSON_PROPERTY_DUE_DATE,
  UserTaskProperties.JSON_PROPERTY_FOLLOW_UP_DATE,
  UserTaskProperties.JSON_PROPERTY_FORM_KEY,
  UserTaskProperties.JSON_PROPERTY_PRIORITY,
  UserTaskProperties.JSON_PROPERTY_USER_TASK_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class UserTaskProperties {
  public static final String JSON_PROPERTY_ACTION = "action";
  @javax.annotation.Nullable private String action;

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  @javax.annotation.Nullable private String assignee;

  public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
  @javax.annotation.Nullable private List<String> candidateGroups = new ArrayList<>();

  public static final String JSON_PROPERTY_CANDIDATE_USERS = "candidateUsers";
  @javax.annotation.Nullable private List<String> candidateUsers = new ArrayList<>();

  public static final String JSON_PROPERTY_CHANGED_ATTRIBUTES = "changedAttributes";
  @javax.annotation.Nullable private List<String> changedAttributes = new ArrayList<>();

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  @javax.annotation.Nullable private String dueDate;

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
  @javax.annotation.Nullable private String followUpDate;

  public static final String JSON_PROPERTY_FORM_KEY = "formKey";
  @javax.annotation.Nullable private String formKey;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  @javax.annotation.Nullable private Integer priority;

  public static final String JSON_PROPERTY_USER_TASK_KEY = "userTaskKey";
  @javax.annotation.Nullable private String userTaskKey;

  public UserTaskProperties() {}

  public UserTaskProperties action(@javax.annotation.Nullable String action) {

    this.action = action;
    return this;
  }

  /**
   * The action performed on the user task.
   *
   * @return action
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ACTION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAction() {
    return action;
  }

  @JsonProperty(value = JSON_PROPERTY_ACTION, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAction(@javax.annotation.Nullable String action) {
    this.action = action;
  }

  public UserTaskProperties assignee(@javax.annotation.Nullable String assignee) {

    this.assignee = assignee;
    return this;
  }

  /**
   * The user assigned to the task.
   *
   * @return assignee
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ASSIGNEE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAssignee() {
    return assignee;
  }

  @JsonProperty(value = JSON_PROPERTY_ASSIGNEE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignee(@javax.annotation.Nullable String assignee) {
    this.assignee = assignee;
  }

  public UserTaskProperties candidateGroups(
      @javax.annotation.Nullable List<String> candidateGroups) {

    this.candidateGroups = candidateGroups;
    return this;
  }

  public UserTaskProperties addCandidateGroupsItem(String candidateGroupsItem) {
    if (this.candidateGroups == null) {
      this.candidateGroups = new ArrayList<>();
    }
    this.candidateGroups.add(candidateGroupsItem);
    return this;
  }

  /**
   * The groups eligible to claim the task.
   *
   * @return candidateGroups
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_GROUPS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCandidateGroups() {
    return candidateGroups;
  }

  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_GROUPS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateGroups(@javax.annotation.Nullable List<String> candidateGroups) {
    this.candidateGroups = candidateGroups;
  }

  public UserTaskProperties candidateUsers(@javax.annotation.Nullable List<String> candidateUsers) {

    this.candidateUsers = candidateUsers;
    return this;
  }

  public UserTaskProperties addCandidateUsersItem(String candidateUsersItem) {
    if (this.candidateUsers == null) {
      this.candidateUsers = new ArrayList<>();
    }
    this.candidateUsers.add(candidateUsersItem);
    return this;
  }

  /**
   * The users eligible to claim the task.
   *
   * @return candidateUsers
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_USERS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCandidateUsers() {
    return candidateUsers;
  }

  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_USERS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateUsers(@javax.annotation.Nullable List<String> candidateUsers) {
    this.candidateUsers = candidateUsers;
  }

  public UserTaskProperties changedAttributes(
      @javax.annotation.Nullable List<String> changedAttributes) {

    this.changedAttributes = changedAttributes;
    return this;
  }

  public UserTaskProperties addChangedAttributesItem(String changedAttributesItem) {
    if (this.changedAttributes == null) {
      this.changedAttributes = new ArrayList<>();
    }
    this.changedAttributes.add(changedAttributesItem);
    return this;
  }

  /**
   * The attributes that were changed in the task.
   *
   * @return changedAttributes
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CHANGED_ATTRIBUTES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getChangedAttributes() {
    return changedAttributes;
  }

  @JsonProperty(value = JSON_PROPERTY_CHANGED_ATTRIBUTES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangedAttributes(@javax.annotation.Nullable List<String> changedAttributes) {
    this.changedAttributes = changedAttributes;
  }

  public UserTaskProperties dueDate(@javax.annotation.Nullable String dueDate) {

    this.dueDate = dueDate;
    return this;
  }

  /**
   * The due date of the user task in ISO 8601 format.
   *
   * @return dueDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DUE_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDueDate() {
    return dueDate;
  }

  @JsonProperty(value = JSON_PROPERTY_DUE_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(@javax.annotation.Nullable String dueDate) {
    this.dueDate = dueDate;
  }

  public UserTaskProperties followUpDate(@javax.annotation.Nullable String followUpDate) {

    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * The follow-up date of the user task in ISO 8601 format.
   *
   * @return followUpDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_FOLLOW_UP_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFollowUpDate() {
    return followUpDate;
  }

  @JsonProperty(value = JSON_PROPERTY_FOLLOW_UP_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowUpDate(@javax.annotation.Nullable String followUpDate) {
    this.followUpDate = followUpDate;
  }

  public UserTaskProperties formKey(@javax.annotation.Nullable String formKey) {

    this.formKey = formKey;
    return this;
  }

  /**
   * The key of the form associated with the user task.
   *
   * @return formKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_FORM_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFormKey() {
    return formKey;
  }

  @JsonProperty(value = JSON_PROPERTY_FORM_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormKey(@javax.annotation.Nullable String formKey) {
    this.formKey = formKey;
  }

  public UserTaskProperties priority(@javax.annotation.Nullable Integer priority) {

    this.priority = priority;
    return this;
  }

  /**
   * The priority of the user task. minimum: 0 maximum: 100
   *
   * @return priority
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PRIORITY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPriority() {
    return priority;
  }

  @JsonProperty(value = JSON_PROPERTY_PRIORITY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(@javax.annotation.Nullable Integer priority) {
    this.priority = priority;
  }

  public UserTaskProperties userTaskKey(@javax.annotation.Nullable String userTaskKey) {

    this.userTaskKey = userTaskKey;
    return this;
  }

  /**
   * The unique key identifying the user task.
   *
   * @return userTaskKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_USER_TASK_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUserTaskKey() {
    return userTaskKey;
  }

  @JsonProperty(value = JSON_PROPERTY_USER_TASK_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserTaskKey(@javax.annotation.Nullable String userTaskKey) {
    this.userTaskKey = userTaskKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskProperties userTaskProperties = (UserTaskProperties) o;
    return Objects.equals(this.action, userTaskProperties.action)
        && Objects.equals(this.assignee, userTaskProperties.assignee)
        && Objects.equals(this.candidateGroups, userTaskProperties.candidateGroups)
        && Objects.equals(this.candidateUsers, userTaskProperties.candidateUsers)
        && Objects.equals(this.changedAttributes, userTaskProperties.changedAttributes)
        && Objects.equals(this.dueDate, userTaskProperties.dueDate)
        && Objects.equals(this.followUpDate, userTaskProperties.followUpDate)
        && Objects.equals(this.formKey, userTaskProperties.formKey)
        && Objects.equals(this.priority, userTaskProperties.priority)
        && Objects.equals(this.userTaskKey, userTaskProperties.userTaskKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        action,
        assignee,
        candidateGroups,
        candidateUsers,
        changedAttributes,
        dueDate,
        followUpDate,
        formKey,
        priority,
        userTaskKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskProperties {\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    candidateGroups: ").append(toIndentedString(candidateGroups)).append("\n");
    sb.append("    candidateUsers: ").append(toIndentedString(candidateUsers)).append("\n");
    sb.append("    changedAttributes: ").append(toIndentedString(changedAttributes)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    userTaskKey: ").append(toIndentedString(userTaskKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
