/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/** User task filter request. */
@JsonPropertyOrder({
  UserTaskFilter.JSON_PROPERTY_STATE,
  UserTaskFilter.JSON_PROPERTY_ASSIGNEE,
  UserTaskFilter.JSON_PROPERTY_PRIORITY,
  UserTaskFilter.JSON_PROPERTY_ELEMENT_ID,
  UserTaskFilter.JSON_PROPERTY_NAME,
  UserTaskFilter.JSON_PROPERTY_CANDIDATE_GROUP,
  UserTaskFilter.JSON_PROPERTY_CANDIDATE_USER,
  UserTaskFilter.JSON_PROPERTY_TENANT_ID,
  UserTaskFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  UserTaskFilter.JSON_PROPERTY_CREATION_DATE,
  UserTaskFilter.JSON_PROPERTY_COMPLETION_DATE,
  UserTaskFilter.JSON_PROPERTY_FOLLOW_UP_DATE,
  UserTaskFilter.JSON_PROPERTY_DUE_DATE,
  UserTaskFilter.JSON_PROPERTY_PROCESS_INSTANCE_VARIABLES,
  UserTaskFilter.JSON_PROPERTY_LOCAL_VARIABLES,
  UserTaskFilter.JSON_PROPERTY_USER_TASK_KEY,
  UserTaskFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  UserTaskFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  UserTaskFilter.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  UserTaskFilter.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class UserTaskFilter {
  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable private UserTaskStateFilterProperty state;

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  @javax.annotation.Nullable private StringFilterProperty assignee;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  @javax.annotation.Nullable private IntegerFilterProperty priority;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable private String elementId;

  public static final String JSON_PROPERTY_NAME = "name";
  @javax.annotation.Nullable private String name;

  public static final String JSON_PROPERTY_CANDIDATE_GROUP = "candidateGroup";
  @javax.annotation.Nullable private StringFilterProperty candidateGroup;

  public static final String JSON_PROPERTY_CANDIDATE_USER = "candidateUser";
  @javax.annotation.Nullable private StringFilterProperty candidateUser;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable private String processDefinitionId;

  public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
  @javax.annotation.Nullable private DateTimeFilterProperty creationDate;

  public static final String JSON_PROPERTY_COMPLETION_DATE = "completionDate";
  @javax.annotation.Nullable private DateTimeFilterProperty completionDate;

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
  @javax.annotation.Nullable private DateTimeFilterProperty followUpDate;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  @javax.annotation.Nullable private DateTimeFilterProperty dueDate;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_VARIABLES = "processInstanceVariables";

  @javax.annotation.Nullable
  private List<VariableValueFilterProperty> processInstanceVariables = new ArrayList<>();

  public static final String JSON_PROPERTY_LOCAL_VARIABLES = "localVariables";

  @javax.annotation.Nullable
  private List<VariableValueFilterProperty> localVariables = new ArrayList<>();

  public static final String JSON_PROPERTY_USER_TASK_KEY = "userTaskKey";
  @javax.annotation.Nullable private String userTaskKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable private String processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable private String processInstanceKey;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable private String elementInstanceKey;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable private Set<String> tags = new LinkedHashSet<>();

  public UserTaskFilter() {}

  public UserTaskFilter state(@javax.annotation.Nullable UserTaskStateFilterProperty state) {

    this.state = state;
    return this;
  }

  /**
   * The user task state.
   *
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public UserTaskStateFilterProperty getState() {
    return state;
  }

  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable UserTaskStateFilterProperty state) {
    this.state = state;
  }

  public UserTaskFilter assignee(@javax.annotation.Nullable StringFilterProperty assignee) {

    this.assignee = assignee;
    return this;
  }

  /**
   * The assignee of the user task.
   *
   * @return assignee
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ASSIGNEE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getAssignee() {
    return assignee;
  }

  @JsonProperty(value = JSON_PROPERTY_ASSIGNEE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignee(@javax.annotation.Nullable StringFilterProperty assignee) {
    this.assignee = assignee;
  }

  public UserTaskFilter priority(@javax.annotation.Nullable IntegerFilterProperty priority) {

    this.priority = priority;
    return this;
  }

  /**
   * The priority of the user task.
   *
   * @return priority
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PRIORITY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IntegerFilterProperty getPriority() {
    return priority;
  }

  @JsonProperty(value = JSON_PROPERTY_PRIORITY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(@javax.annotation.Nullable IntegerFilterProperty priority) {
    this.priority = priority;
  }

  public UserTaskFilter elementId(@javax.annotation.Nullable String elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID of the user task.
   *
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable String elementId) {
    this.elementId = elementId;
  }

  public UserTaskFilter name(@javax.annotation.Nullable String name) {

    this.name = name;
    return this;
  }

  /**
   * The task name. This only works for data created with 8.8 and onwards. Instances from prior
   * versions don&#39;t contain this data and cannot be found.
   *
   * @return name
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  @JsonProperty(value = JSON_PROPERTY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@javax.annotation.Nullable String name) {
    this.name = name;
  }

  public UserTaskFilter candidateGroup(
      @javax.annotation.Nullable StringFilterProperty candidateGroup) {

    this.candidateGroup = candidateGroup;
    return this;
  }

  /**
   * The candidate group for this user task.
   *
   * @return candidateGroup
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_GROUP, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getCandidateGroup() {
    return candidateGroup;
  }

  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_GROUP, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateGroup(@javax.annotation.Nullable StringFilterProperty candidateGroup) {
    this.candidateGroup = candidateGroup;
  }

  public UserTaskFilter candidateUser(
      @javax.annotation.Nullable StringFilterProperty candidateUser) {

    this.candidateUser = candidateUser;
    return this;
  }

  /**
   * The candidate user for this user task.
   *
   * @return candidateUser
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_USER, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getCandidateUser() {
    return candidateUser;
  }

  @JsonProperty(value = JSON_PROPERTY_CANDIDATE_USER, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateUser(@javax.annotation.Nullable StringFilterProperty candidateUser) {
    this.candidateUser = candidateUser;
  }

  public UserTaskFilter tenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * Tenant ID of this user task.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public UserTaskFilter processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The ID of the process definition.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public UserTaskFilter creationDate(
      @javax.annotation.Nullable DateTimeFilterProperty creationDate) {

    this.creationDate = creationDate;
    return this;
  }

  /**
   * The user task creation date.
   *
   * @return creationDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CREATION_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getCreationDate() {
    return creationDate;
  }

  @JsonProperty(value = JSON_PROPERTY_CREATION_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationDate(@javax.annotation.Nullable DateTimeFilterProperty creationDate) {
    this.creationDate = creationDate;
  }

  public UserTaskFilter completionDate(
      @javax.annotation.Nullable DateTimeFilterProperty completionDate) {

    this.completionDate = completionDate;
    return this;
  }

  /**
   * The user task completion date.
   *
   * @return completionDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_COMPLETION_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getCompletionDate() {
    return completionDate;
  }

  @JsonProperty(value = JSON_PROPERTY_COMPLETION_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompletionDate(@javax.annotation.Nullable DateTimeFilterProperty completionDate) {
    this.completionDate = completionDate;
  }

  public UserTaskFilter followUpDate(
      @javax.annotation.Nullable DateTimeFilterProperty followUpDate) {

    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * The user task follow-up date.
   *
   * @return followUpDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_FOLLOW_UP_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getFollowUpDate() {
    return followUpDate;
  }

  @JsonProperty(value = JSON_PROPERTY_FOLLOW_UP_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowUpDate(@javax.annotation.Nullable DateTimeFilterProperty followUpDate) {
    this.followUpDate = followUpDate;
  }

  public UserTaskFilter dueDate(@javax.annotation.Nullable DateTimeFilterProperty dueDate) {

    this.dueDate = dueDate;
    return this;
  }

  /**
   * The user task due date.
   *
   * @return dueDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DUE_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getDueDate() {
    return dueDate;
  }

  @JsonProperty(value = JSON_PROPERTY_DUE_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(@javax.annotation.Nullable DateTimeFilterProperty dueDate) {
    this.dueDate = dueDate;
  }

  public UserTaskFilter processInstanceVariables(
      @javax.annotation.Nullable List<VariableValueFilterProperty> processInstanceVariables) {

    this.processInstanceVariables = processInstanceVariables;
    return this;
  }

  public UserTaskFilter addProcessInstanceVariablesItem(
      VariableValueFilterProperty processInstanceVariablesItem) {
    if (this.processInstanceVariables == null) {
      this.processInstanceVariables = new ArrayList<>();
    }
    this.processInstanceVariables.add(processInstanceVariablesItem);
    return this;
  }

  /**
   * Get processInstanceVariables
   *
   * @return processInstanceVariables
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<VariableValueFilterProperty> getProcessInstanceVariables() {
    return processInstanceVariables;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceVariables(
      @javax.annotation.Nullable List<VariableValueFilterProperty> processInstanceVariables) {
    this.processInstanceVariables = processInstanceVariables;
  }

  public UserTaskFilter localVariables(
      @javax.annotation.Nullable List<VariableValueFilterProperty> localVariables) {

    this.localVariables = localVariables;
    return this;
  }

  public UserTaskFilter addLocalVariablesItem(VariableValueFilterProperty localVariablesItem) {
    if (this.localVariables == null) {
      this.localVariables = new ArrayList<>();
    }
    this.localVariables.add(localVariablesItem);
    return this;
  }

  /**
   * Get localVariables
   *
   * @return localVariables
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_LOCAL_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<VariableValueFilterProperty> getLocalVariables() {
    return localVariables;
  }

  @JsonProperty(value = JSON_PROPERTY_LOCAL_VARIABLES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalVariables(
      @javax.annotation.Nullable List<VariableValueFilterProperty> localVariables) {
    this.localVariables = localVariables;
  }

  public UserTaskFilter userTaskKey(@javax.annotation.Nullable String userTaskKey) {

    this.userTaskKey = userTaskKey;
    return this;
  }

  /**
   * The key for this user task.
   *
   * @return userTaskKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_USER_TASK_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUserTaskKey() {
    return userTaskKey;
  }

  @JsonProperty(value = JSON_PROPERTY_USER_TASK_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserTaskKey(@javax.annotation.Nullable String userTaskKey) {
    this.userTaskKey = userTaskKey;
  }

  public UserTaskFilter processDefinitionKey(
      @javax.annotation.Nullable String processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public UserTaskFilter processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of the process instance.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public UserTaskFilter elementInstanceKey(@javax.annotation.Nullable String elementInstanceKey) {

    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The key of the element instance.
   *
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getElementInstanceKey() {
    return elementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(@javax.annotation.Nullable String elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public UserTaskFilter tags(@javax.annotation.Nullable Set<String> tags) {

    this.tags = tags;
    return this;
  }

  public UserTaskFilter addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags. Tags need to start with a letter; then alphanumerics, &#x60;_&#x60;,
   * &#x60;-&#x60;, &#x60;:&#x60;, or &#x60;.&#x60;; length ≤ 100.
   *
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<String> getTags() {
    return tags;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserTaskFilter userTaskFilter = (UserTaskFilter) o;
    return Objects.equals(this.state, userTaskFilter.state)
        && Objects.equals(this.assignee, userTaskFilter.assignee)
        && Objects.equals(this.priority, userTaskFilter.priority)
        && Objects.equals(this.elementId, userTaskFilter.elementId)
        && Objects.equals(this.name, userTaskFilter.name)
        && Objects.equals(this.candidateGroup, userTaskFilter.candidateGroup)
        && Objects.equals(this.candidateUser, userTaskFilter.candidateUser)
        && Objects.equals(this.tenantId, userTaskFilter.tenantId)
        && Objects.equals(this.processDefinitionId, userTaskFilter.processDefinitionId)
        && Objects.equals(this.creationDate, userTaskFilter.creationDate)
        && Objects.equals(this.completionDate, userTaskFilter.completionDate)
        && Objects.equals(this.followUpDate, userTaskFilter.followUpDate)
        && Objects.equals(this.dueDate, userTaskFilter.dueDate)
        && Objects.equals(this.processInstanceVariables, userTaskFilter.processInstanceVariables)
        && Objects.equals(this.localVariables, userTaskFilter.localVariables)
        && Objects.equals(this.userTaskKey, userTaskFilter.userTaskKey)
        && Objects.equals(this.processDefinitionKey, userTaskFilter.processDefinitionKey)
        && Objects.equals(this.processInstanceKey, userTaskFilter.processInstanceKey)
        && Objects.equals(this.elementInstanceKey, userTaskFilter.elementInstanceKey)
        && Objects.equals(this.tags, userTaskFilter.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        state,
        assignee,
        priority,
        elementId,
        name,
        candidateGroup,
        candidateUser,
        tenantId,
        processDefinitionId,
        creationDate,
        completionDate,
        followUpDate,
        dueDate,
        processInstanceVariables,
        localVariables,
        userTaskKey,
        processDefinitionKey,
        processInstanceKey,
        elementInstanceKey,
        tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserTaskFilter {\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    candidateGroup: ").append(toIndentedString(candidateGroup)).append("\n");
    sb.append("    candidateUser: ").append(toIndentedString(candidateUser)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    completionDate: ").append(toIndentedString(completionDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    processInstanceVariables: ")
        .append(toIndentedString(processInstanceVariables))
        .append("\n");
    sb.append("    localVariables: ").append(toIndentedString(localVariables)).append("\n");
    sb.append("    userTaskKey: ").append(toIndentedString(userTaskKey)).append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
