/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** UsageMetricsResponse */
@JsonPropertyOrder({
  UsageMetricsResponse.JSON_PROPERTY_PROCESS_INSTANCES,
  UsageMetricsResponse.JSON_PROPERTY_DECISION_INSTANCES,
  UsageMetricsResponse.JSON_PROPERTY_ASSIGNEES,
  UsageMetricsResponse.JSON_PROPERTY_ACTIVE_TENANTS,
  UsageMetricsResponse.JSON_PROPERTY_TENANTS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class UsageMetricsResponse {
  public static final String JSON_PROPERTY_PROCESS_INSTANCES = "processInstances";
  @javax.annotation.Nullable private Long processInstances;

  public static final String JSON_PROPERTY_DECISION_INSTANCES = "decisionInstances";
  @javax.annotation.Nullable private Long decisionInstances;

  public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
  @javax.annotation.Nullable private Long assignees;

  public static final String JSON_PROPERTY_ACTIVE_TENANTS = "activeTenants";
  @javax.annotation.Nullable private Long activeTenants;

  public static final String JSON_PROPERTY_TENANTS = "tenants";

  @javax.annotation.Nullable
  private Map<String, UsageMetricsResponseItem> tenants = new HashMap<>();

  public UsageMetricsResponse() {}

  public UsageMetricsResponse processInstances(@javax.annotation.Nullable Long processInstances) {

    this.processInstances = processInstances;
    return this;
  }

  /**
   * The amount of created root process instances.
   *
   * @return processInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getProcessInstances() {
    return processInstances;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstances(@javax.annotation.Nullable Long processInstances) {
    this.processInstances = processInstances;
  }

  public UsageMetricsResponse decisionInstances(@javax.annotation.Nullable Long decisionInstances) {

    this.decisionInstances = decisionInstances;
    return this;
  }

  /**
   * The amount of executed decision instances.
   *
   * @return decisionInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DECISION_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getDecisionInstances() {
    return decisionInstances;
  }

  @JsonProperty(value = JSON_PROPERTY_DECISION_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionInstances(@javax.annotation.Nullable Long decisionInstances) {
    this.decisionInstances = decisionInstances;
  }

  public UsageMetricsResponse assignees(@javax.annotation.Nullable Long assignees) {

    this.assignees = assignees;
    return this;
  }

  /**
   * The amount of unique active task users.
   *
   * @return assignees
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ASSIGNEES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getAssignees() {
    return assignees;
  }

  @JsonProperty(value = JSON_PROPERTY_ASSIGNEES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignees(@javax.annotation.Nullable Long assignees) {
    this.assignees = assignees;
  }

  public UsageMetricsResponse activeTenants(@javax.annotation.Nullable Long activeTenants) {

    this.activeTenants = activeTenants;
    return this;
  }

  /**
   * The amount of active tenants.
   *
   * @return activeTenants
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ACTIVE_TENANTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getActiveTenants() {
    return activeTenants;
  }

  @JsonProperty(value = JSON_PROPERTY_ACTIVE_TENANTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveTenants(@javax.annotation.Nullable Long activeTenants) {
    this.activeTenants = activeTenants;
  }

  public UsageMetricsResponse tenants(
      @javax.annotation.Nullable Map<String, UsageMetricsResponseItem> tenants) {

    this.tenants = tenants;
    return this;
  }

  public UsageMetricsResponse putTenantsItem(String key, UsageMetricsResponseItem tenantsItem) {
    if (this.tenants == null) {
      this.tenants = new HashMap<>();
    }
    this.tenants.put(key, tenantsItem);
    return this;
  }

  /**
   * The usage metrics by tenants. Only available if request &#x60;withTenants&#x60; query parameter
   * was &#x60;true&#x60;.
   *
   * @return tenants
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, UsageMetricsResponseItem> getTenants() {
    return tenants;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenants(@javax.annotation.Nullable Map<String, UsageMetricsResponseItem> tenants) {
    this.tenants = tenants;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UsageMetricsResponse usageMetricsResponse = (UsageMetricsResponse) o;
    return Objects.equals(this.processInstances, usageMetricsResponse.processInstances)
        && Objects.equals(this.decisionInstances, usageMetricsResponse.decisionInstances)
        && Objects.equals(this.assignees, usageMetricsResponse.assignees)
        && Objects.equals(this.activeTenants, usageMetricsResponse.activeTenants)
        && Objects.equals(this.tenants, usageMetricsResponse.tenants);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processInstances, decisionInstances, assignees, activeTenants, tenants);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UsageMetricsResponse {\n");
    sb.append("    processInstances: ").append(toIndentedString(processInstances)).append("\n");
    sb.append("    decisionInstances: ").append(toIndentedString(decisionInstances)).append("\n");
    sb.append("    assignees: ").append(toIndentedString(assignees)).append("\n");
    sb.append("    activeTenants: ").append(toIndentedString(activeTenants)).append("\n");
    sb.append("    tenants: ").append(toIndentedString(tenants)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
