/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** The response of a topology request. */
@JsonPropertyOrder({
  TopologyResponse.JSON_PROPERTY_BROKERS,
  TopologyResponse.JSON_PROPERTY_CLUSTER_ID,
  TopologyResponse.JSON_PROPERTY_CLUSTER_SIZE,
  TopologyResponse.JSON_PROPERTY_PARTITIONS_COUNT,
  TopologyResponse.JSON_PROPERTY_REPLICATION_FACTOR,
  TopologyResponse.JSON_PROPERTY_GATEWAY_VERSION,
  TopologyResponse.JSON_PROPERTY_LAST_COMPLETED_CHANGE_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class TopologyResponse {
  public static final String JSON_PROPERTY_BROKERS = "brokers";
  @javax.annotation.Nonnull private List<BrokerInfo> brokers = new ArrayList<>();

  public static final String JSON_PROPERTY_CLUSTER_ID = "clusterId";
  @javax.annotation.Nullable private String clusterId;

  public static final String JSON_PROPERTY_CLUSTER_SIZE = "clusterSize";
  @javax.annotation.Nonnull private Integer clusterSize;

  public static final String JSON_PROPERTY_PARTITIONS_COUNT = "partitionsCount";
  @javax.annotation.Nonnull private Integer partitionsCount;

  public static final String JSON_PROPERTY_REPLICATION_FACTOR = "replicationFactor";
  @javax.annotation.Nonnull private Integer replicationFactor;

  public static final String JSON_PROPERTY_GATEWAY_VERSION = "gatewayVersion";
  @javax.annotation.Nonnull private String gatewayVersion;

  public static final String JSON_PROPERTY_LAST_COMPLETED_CHANGE_ID = "lastCompletedChangeId";
  @javax.annotation.Nonnull private String lastCompletedChangeId;

  public TopologyResponse() {}

  public TopologyResponse brokers(@javax.annotation.Nonnull List<BrokerInfo> brokers) {

    this.brokers = brokers;
    return this;
  }

  public TopologyResponse addBrokersItem(BrokerInfo brokersItem) {
    if (this.brokers == null) {
      this.brokers = new ArrayList<>();
    }
    this.brokers.add(brokersItem);
    return this;
  }

  /**
   * A list of brokers that are part of this cluster.
   *
   * @return brokers
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_BROKERS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<BrokerInfo> getBrokers() {
    return brokers;
  }

  @JsonProperty(value = JSON_PROPERTY_BROKERS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrokers(@javax.annotation.Nonnull List<BrokerInfo> brokers) {
    this.brokers = brokers;
  }

  public TopologyResponse clusterId(@javax.annotation.Nullable String clusterId) {

    this.clusterId = clusterId;
    return this;
  }

  /**
   * The cluster Id.
   *
   * @return clusterId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CLUSTER_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty(value = JSON_PROPERTY_CLUSTER_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClusterId(@javax.annotation.Nullable String clusterId) {
    this.clusterId = clusterId;
  }

  public TopologyResponse clusterSize(@javax.annotation.Nonnull Integer clusterSize) {

    this.clusterSize = clusterSize;
    return this;
  }

  /**
   * The number of brokers in the cluster.
   *
   * @return clusterSize
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_CLUSTER_SIZE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getClusterSize() {
    return clusterSize;
  }

  @JsonProperty(value = JSON_PROPERTY_CLUSTER_SIZE, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClusterSize(@javax.annotation.Nonnull Integer clusterSize) {
    this.clusterSize = clusterSize;
  }

  public TopologyResponse partitionsCount(@javax.annotation.Nonnull Integer partitionsCount) {

    this.partitionsCount = partitionsCount;
    return this;
  }

  /**
   * The number of partitions are spread across the cluster.
   *
   * @return partitionsCount
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PARTITIONS_COUNT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getPartitionsCount() {
    return partitionsCount;
  }

  @JsonProperty(value = JSON_PROPERTY_PARTITIONS_COUNT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPartitionsCount(@javax.annotation.Nonnull Integer partitionsCount) {
    this.partitionsCount = partitionsCount;
  }

  public TopologyResponse replicationFactor(@javax.annotation.Nonnull Integer replicationFactor) {

    this.replicationFactor = replicationFactor;
    return this;
  }

  /**
   * The configured replication factor for this cluster.
   *
   * @return replicationFactor
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_REPLICATION_FACTOR, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getReplicationFactor() {
    return replicationFactor;
  }

  @JsonProperty(value = JSON_PROPERTY_REPLICATION_FACTOR, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReplicationFactor(@javax.annotation.Nonnull Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
  }

  public TopologyResponse gatewayVersion(@javax.annotation.Nonnull String gatewayVersion) {

    this.gatewayVersion = gatewayVersion;
    return this;
  }

  /**
   * The version of the Zeebe Gateway.
   *
   * @return gatewayVersion
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_GATEWAY_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getGatewayVersion() {
    return gatewayVersion;
  }

  @JsonProperty(value = JSON_PROPERTY_GATEWAY_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGatewayVersion(@javax.annotation.Nonnull String gatewayVersion) {
    this.gatewayVersion = gatewayVersion;
  }

  public TopologyResponse lastCompletedChangeId(
      @javax.annotation.Nonnull String lastCompletedChangeId) {

    this.lastCompletedChangeId = lastCompletedChangeId;
    return this;
  }

  /**
   * ID of the last completed change
   *
   * @return lastCompletedChangeId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_LAST_COMPLETED_CHANGE_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getLastCompletedChangeId() {
    return lastCompletedChangeId;
  }

  @JsonProperty(value = JSON_PROPERTY_LAST_COMPLETED_CHANGE_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastCompletedChangeId(@javax.annotation.Nonnull String lastCompletedChangeId) {
    this.lastCompletedChangeId = lastCompletedChangeId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TopologyResponse topologyResponse = (TopologyResponse) o;
    return Objects.equals(this.brokers, topologyResponse.brokers)
        && Objects.equals(this.clusterId, topologyResponse.clusterId)
        && Objects.equals(this.clusterSize, topologyResponse.clusterSize)
        && Objects.equals(this.partitionsCount, topologyResponse.partitionsCount)
        && Objects.equals(this.replicationFactor, topologyResponse.replicationFactor)
        && Objects.equals(this.gatewayVersion, topologyResponse.gatewayVersion)
        && Objects.equals(this.lastCompletedChangeId, topologyResponse.lastCompletedChangeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        brokers,
        clusterId,
        clusterSize,
        partitionsCount,
        replicationFactor,
        gatewayVersion,
        lastCompletedChangeId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TopologyResponse {\n");
    sb.append("    brokers: ").append(toIndentedString(brokers)).append("\n");
    sb.append("    clusterId: ").append(toIndentedString(clusterId)).append("\n");
    sb.append("    clusterSize: ").append(toIndentedString(clusterSize)).append("\n");
    sb.append("    partitionsCount: ").append(toIndentedString(partitionsCount)).append("\n");
    sb.append("    replicationFactor: ").append(toIndentedString(replicationFactor)).append("\n");
    sb.append("    gatewayVersion: ").append(toIndentedString(gatewayVersion)).append("\n");
    sb.append("    lastCompletedChangeId: ")
        .append(toIndentedString(lastCompletedChangeId))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
