/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** MessagePublicationRequest */
@JsonPropertyOrder({
  MessagePublicationRequest.JSON_PROPERTY_NAME,
  MessagePublicationRequest.JSON_PROPERTY_CORRELATION_KEY,
  MessagePublicationRequest.JSON_PROPERTY_TIME_TO_LIVE,
  MessagePublicationRequest.JSON_PROPERTY_MESSAGE_ID,
  MessagePublicationRequest.JSON_PROPERTY_VARIABLES,
  MessagePublicationRequest.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class MessagePublicationRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @javax.annotation.Nonnull private String name;

  public static final String JSON_PROPERTY_CORRELATION_KEY = "correlationKey";
  @javax.annotation.Nullable private String correlationKey = "";

  public static final String JSON_PROPERTY_TIME_TO_LIVE = "timeToLive";
  @javax.annotation.Nullable private Long timeToLive = 0l;

  public static final String JSON_PROPERTY_MESSAGE_ID = "messageId";
  @javax.annotation.Nullable private String messageId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private String tenantId;

  public MessagePublicationRequest() {}

  public MessagePublicationRequest name(@javax.annotation.Nonnull String name) {

    this.name = name;
    return this;
  }

  /**
   * The name of the message.
   *
   * @return name
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }

  @JsonProperty(value = JSON_PROPERTY_NAME, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@javax.annotation.Nonnull String name) {
    this.name = name;
  }

  public MessagePublicationRequest correlationKey(
      @javax.annotation.Nullable String correlationKey) {

    this.correlationKey = correlationKey;
    return this;
  }

  /**
   * The correlation key of the message.
   *
   * @return correlationKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CORRELATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCorrelationKey() {
    return correlationKey;
  }

  @JsonProperty(value = JSON_PROPERTY_CORRELATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorrelationKey(@javax.annotation.Nullable String correlationKey) {
    this.correlationKey = correlationKey;
  }

  public MessagePublicationRequest timeToLive(@javax.annotation.Nullable Long timeToLive) {

    this.timeToLive = timeToLive;
    return this;
  }

  /**
   * Timespan (in ms) to buffer the message on the broker.
   *
   * @return timeToLive
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TIME_TO_LIVE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getTimeToLive() {
    return timeToLive;
  }

  @JsonProperty(value = JSON_PROPERTY_TIME_TO_LIVE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeToLive(@javax.annotation.Nullable Long timeToLive) {
    this.timeToLive = timeToLive;
  }

  public MessagePublicationRequest messageId(@javax.annotation.Nullable String messageId) {

    this.messageId = messageId;
    return this;
  }

  /**
   * The unique ID of the message. This is used to ensure only one message with the given ID will be
   * published during the lifetime of the message (if &#x60;timeToLive&#x60; is set).
   *
   * @return messageId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_MESSAGE_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessageId() {
    return messageId;
  }

  @JsonProperty(value = JSON_PROPERTY_MESSAGE_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageId(@javax.annotation.Nullable String messageId) {
    this.messageId = messageId;
  }

  public MessagePublicationRequest variables(
      @javax.annotation.Nullable Map<String, Object> variables) {

    this.variables = variables;
    return this;
  }

  public MessagePublicationRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The message variables as JSON document.
   *
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = false)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Object> getVariables() {
    return variables;
  }

  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = false)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable Map<String, Object> variables) {
    this.variables = variables;
  }

  public MessagePublicationRequest tenantId(@javax.annotation.Nullable String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant of the message sender.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessagePublicationRequest messagePublicationRequest = (MessagePublicationRequest) o;
    return Objects.equals(this.name, messagePublicationRequest.name)
        && Objects.equals(this.correlationKey, messagePublicationRequest.correlationKey)
        && Objects.equals(this.timeToLive, messagePublicationRequest.timeToLive)
        && Objects.equals(this.messageId, messagePublicationRequest.messageId)
        && Objects.equals(this.variables, messagePublicationRequest.variables)
        && Objects.equals(this.tenantId, messagePublicationRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, correlationKey, timeToLive, messageId, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessagePublicationRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    correlationKey: ").append(toIndentedString(correlationKey)).append("\n");
    sb.append("    timeToLive: ").append(toIndentedString(timeToLive)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
