/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/**
 * Job result details for a user task completion, optionally including a denial reason and corrected
 * task properties.
 */
@JsonPropertyOrder({
  JobResultUserTask.JSON_PROPERTY_DENIED,
  JobResultUserTask.JSON_PROPERTY_DENIED_REASON,
  JobResultUserTask.JSON_PROPERTY_CORRECTIONS,
  JobResultUserTask.JSON_PROPERTY_TYPE
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class JobResultUserTask {
  public static final String JSON_PROPERTY_DENIED = "denied";
  @javax.annotation.Nullable private Boolean denied;

  public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
  @javax.annotation.Nullable private String deniedReason;

  public static final String JSON_PROPERTY_CORRECTIONS = "corrections";
  @javax.annotation.Nullable private JobResultCorrections corrections;

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable private String type;

  public JobResultUserTask() {}

  public JobResultUserTask denied(@javax.annotation.Nullable Boolean denied) {

    this.denied = denied;
    return this;
  }

  /**
   * Indicates whether the worker denies the work, i.e. explicitly doesn&#39;t approve it. For
   * example, a user task listener can deny the completion of a task by setting this flag to true.
   * In this example, the completion of a task is represented by a job that the worker can complete
   * as denied. As a result, the completion request is rejected and the task remains active.
   * Defaults to false.
   *
   * @return denied
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DENIED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDenied() {
    return denied;
  }

  @JsonProperty(value = JSON_PROPERTY_DENIED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDenied(@javax.annotation.Nullable Boolean denied) {
    this.denied = denied;
  }

  public JobResultUserTask deniedReason(@javax.annotation.Nullable String deniedReason) {

    this.deniedReason = deniedReason;
    return this;
  }

  /**
   * The reason provided by the user task listener for denying the work.
   *
   * @return deniedReason
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DENIED_REASON, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeniedReason() {
    return deniedReason;
  }

  @JsonProperty(value = JSON_PROPERTY_DENIED_REASON, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeniedReason(@javax.annotation.Nullable String deniedReason) {
    this.deniedReason = deniedReason;
  }

  public JobResultUserTask corrections(
      @javax.annotation.Nullable JobResultCorrections corrections) {

    this.corrections = corrections;
    return this;
  }

  /**
   * Get corrections
   *
   * @return corrections
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CORRECTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobResultCorrections getCorrections() {
    return corrections;
  }

  @JsonProperty(value = JSON_PROPERTY_CORRECTIONS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorrections(@javax.annotation.Nullable JobResultCorrections corrections) {
    this.corrections = corrections;
  }

  public JobResultUserTask type(@javax.annotation.Nullable String type) {

    this.type = type;
    return this;
  }

  /**
   * Used to distinguish between different types of job results.
   *
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable String type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobResultUserTask jobResultUserTask = (JobResultUserTask) o;
    return Objects.equals(this.denied, jobResultUserTask.denied)
        && Objects.equals(this.deniedReason, jobResultUserTask.deniedReason)
        && Objects.equals(this.corrections, jobResultUserTask.corrections)
        && Objects.equals(this.type, jobResultUserTask.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(denied, deniedReason, corrections, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobResultUserTask {\n");
    sb.append("    denied: ").append(toIndentedString(denied)).append("\n");
    sb.append("    deniedReason: ").append(toIndentedString(deniedReason)).append("\n");
    sb.append("    corrections: ").append(toIndentedString(corrections)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
