/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Job result details for an ad‑hoc sub‑process, including elements to activate and flags indicating
 * completion or cancellation behavior.
 */
@JsonPropertyOrder({
  JobResultAdHocSubProcess.JSON_PROPERTY_ACTIVATE_ELEMENTS,
  JobResultAdHocSubProcess.JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED,
  JobResultAdHocSubProcess.JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES,
  JobResultAdHocSubProcess.JSON_PROPERTY_TYPE
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class JobResultAdHocSubProcess {
  public static final String JSON_PROPERTY_ACTIVATE_ELEMENTS = "activateElements";

  @javax.annotation.Nullable
  private List<JobResultActivateElement> activateElements = new ArrayList<>();

  public static final String JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED =
      "isCompletionConditionFulfilled";
  @javax.annotation.Nullable private Boolean isCompletionConditionFulfilled = false;

  public static final String JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES =
      "isCancelRemainingInstances";
  @javax.annotation.Nullable private Boolean isCancelRemainingInstances = false;

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable private String type;

  public JobResultAdHocSubProcess() {}

  public JobResultAdHocSubProcess activateElements(
      @javax.annotation.Nullable List<JobResultActivateElement> activateElements) {

    this.activateElements = activateElements;
    return this;
  }

  public JobResultAdHocSubProcess addActivateElementsItem(
      JobResultActivateElement activateElementsItem) {
    if (this.activateElements == null) {
      this.activateElements = new ArrayList<>();
    }
    this.activateElements.add(activateElementsItem);
    return this;
  }

  /**
   * Indicates which elements need to be activated in the ad-hoc subprocess.
   *
   * @return activateElements
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ACTIVATE_ELEMENTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<JobResultActivateElement> getActivateElements() {
    return activateElements;
  }

  @JsonProperty(value = JSON_PROPERTY_ACTIVATE_ELEMENTS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivateElements(
      @javax.annotation.Nullable List<JobResultActivateElement> activateElements) {
    this.activateElements = activateElements;
  }

  public JobResultAdHocSubProcess isCompletionConditionFulfilled(
      @javax.annotation.Nullable Boolean isCompletionConditionFulfilled) {

    this.isCompletionConditionFulfilled = isCompletionConditionFulfilled;
    return this;
  }

  /**
   * Indicates whether the completion condition of the ad-hoc subprocess is fulfilled.
   *
   * @return isCompletionConditionFulfilled
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsCompletionConditionFulfilled() {
    return isCompletionConditionFulfilled;
  }

  @JsonProperty(value = JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCompletionConditionFulfilled(
      @javax.annotation.Nullable Boolean isCompletionConditionFulfilled) {
    this.isCompletionConditionFulfilled = isCompletionConditionFulfilled;
  }

  public JobResultAdHocSubProcess isCancelRemainingInstances(
      @javax.annotation.Nullable Boolean isCancelRemainingInstances) {

    this.isCancelRemainingInstances = isCancelRemainingInstances;
    return this;
  }

  /**
   * Indicates whether the remaining instances of the ad-hoc subprocess should be canceled.
   *
   * @return isCancelRemainingInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsCancelRemainingInstances() {
    return isCancelRemainingInstances;
  }

  @JsonProperty(value = JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancelRemainingInstances(
      @javax.annotation.Nullable Boolean isCancelRemainingInstances) {
    this.isCancelRemainingInstances = isCancelRemainingInstances;
  }

  public JobResultAdHocSubProcess type(@javax.annotation.Nullable String type) {

    this.type = type;
    return this;
  }

  /**
   * Used to distinguish between different types of job results.
   *
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable String type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobResultAdHocSubProcess jobResultAdHocSubProcess = (JobResultAdHocSubProcess) o;
    return Objects.equals(this.activateElements, jobResultAdHocSubProcess.activateElements)
        && Objects.equals(
            this.isCompletionConditionFulfilled,
            jobResultAdHocSubProcess.isCompletionConditionFulfilled)
        && Objects.equals(
            this.isCancelRemainingInstances, jobResultAdHocSubProcess.isCancelRemainingInstances)
        && Objects.equals(this.type, jobResultAdHocSubProcess.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        activateElements, isCompletionConditionFulfilled, isCancelRemainingInstances, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobResultAdHocSubProcess {\n");
    sb.append("    activateElements: ").append(toIndentedString(activateElements)).append("\n");
    sb.append("    isCompletionConditionFulfilled: ")
        .append(toIndentedString(isCompletionConditionFulfilled))
        .append("\n");
    sb.append("    isCancelRemainingInstances: ")
        .append(toIndentedString(isCancelRemainingInstances))
        .append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
