/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** Job search filter. */
@JsonPropertyOrder({
  JobFilter.JSON_PROPERTY_DEADLINE,
  JobFilter.JSON_PROPERTY_DENIED_REASON,
  JobFilter.JSON_PROPERTY_ELEMENT_ID,
  JobFilter.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  JobFilter.JSON_PROPERTY_END_TIME,
  JobFilter.JSON_PROPERTY_ERROR_CODE,
  JobFilter.JSON_PROPERTY_ERROR_MESSAGE,
  JobFilter.JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT,
  JobFilter.JSON_PROPERTY_IS_DENIED,
  JobFilter.JSON_PROPERTY_JOB_KEY,
  JobFilter.JSON_PROPERTY_KIND,
  JobFilter.JSON_PROPERTY_LISTENER_EVENT_TYPE,
  JobFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  JobFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  JobFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  JobFilter.JSON_PROPERTY_RETRIES,
  JobFilter.JSON_PROPERTY_STATE,
  JobFilter.JSON_PROPERTY_TENANT_ID,
  JobFilter.JSON_PROPERTY_TYPE,
  JobFilter.JSON_PROPERTY_WORKER,
  JobFilter.JSON_PROPERTY_CREATION_TIME,
  JobFilter.JSON_PROPERTY_LAST_UPDATE_TIME
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class JobFilter {
  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  @javax.annotation.Nullable private DateTimeFilterProperty deadline;

  public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
  @javax.annotation.Nullable private StringFilterProperty deniedReason;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable private StringFilterProperty elementId;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable private ElementInstanceKeyFilterProperty elementInstanceKey;

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  @javax.annotation.Nullable private DateTimeFilterProperty endTime;

  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  @javax.annotation.Nullable private StringFilterProperty errorCode;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable private StringFilterProperty errorMessage;

  public static final String JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT =
      "hasFailedWithRetriesLeft";
  @javax.annotation.Nullable private Boolean hasFailedWithRetriesLeft;

  public static final String JSON_PROPERTY_IS_DENIED = "isDenied";
  @javax.annotation.Nullable private Boolean isDenied;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  @javax.annotation.Nullable private JobKeyFilterProperty jobKey;

  public static final String JSON_PROPERTY_KIND = "kind";
  @javax.annotation.Nullable private JobKindFilterProperty kind;

  public static final String JSON_PROPERTY_LISTENER_EVENT_TYPE = "listenerEventType";
  @javax.annotation.Nullable private JobListenerEventTypeFilterProperty listenerEventType;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable private ProcessDefinitionKeyFilterProperty processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable private ProcessInstanceKeyFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  @javax.annotation.Nullable private IntegerFilterProperty retries;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable private JobStateFilterProperty state;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable private StringFilterProperty type;

  public static final String JSON_PROPERTY_WORKER = "worker";
  @javax.annotation.Nullable private StringFilterProperty worker;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  @javax.annotation.Nullable private DateTimeFilterProperty creationTime;

  public static final String JSON_PROPERTY_LAST_UPDATE_TIME = "lastUpdateTime";
  @javax.annotation.Nullable private DateTimeFilterProperty lastUpdateTime;

  public JobFilter() {}

  public JobFilter deadline(@javax.annotation.Nullable DateTimeFilterProperty deadline) {

    this.deadline = deadline;
    return this;
  }

  /**
   * When the job can next be activated.
   *
   * @return deadline
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DEADLINE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getDeadline() {
    return deadline;
  }

  @JsonProperty(value = JSON_PROPERTY_DEADLINE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeadline(@javax.annotation.Nullable DateTimeFilterProperty deadline) {
    this.deadline = deadline;
  }

  public JobFilter deniedReason(@javax.annotation.Nullable StringFilterProperty deniedReason) {

    this.deniedReason = deniedReason;
    return this;
  }

  /**
   * The reason provided by the user task listener for denying the work.
   *
   * @return deniedReason
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_DENIED_REASON, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getDeniedReason() {
    return deniedReason;
  }

  @JsonProperty(value = JSON_PROPERTY_DENIED_REASON, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeniedReason(@javax.annotation.Nullable StringFilterProperty deniedReason) {
    this.deniedReason = deniedReason;
  }

  public JobFilter elementId(@javax.annotation.Nullable StringFilterProperty elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID associated with the job.
   *
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    this.elementId = elementId;
  }

  public JobFilter elementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty elementInstanceKey) {

    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The element instance key associated with the job.
   *
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ElementInstanceKeyFilterProperty getElementInstanceKey() {
    return elementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public JobFilter endTime(@javax.annotation.Nullable DateTimeFilterProperty endTime) {

    this.endTime = endTime;
    return this;
  }

  /**
   * When the job ended.
   *
   * @return endTime
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_END_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getEndTime() {
    return endTime;
  }

  @JsonProperty(value = JSON_PROPERTY_END_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndTime(@javax.annotation.Nullable DateTimeFilterProperty endTime) {
    this.endTime = endTime;
  }

  public JobFilter errorCode(@javax.annotation.Nullable StringFilterProperty errorCode) {

    this.errorCode = errorCode;
    return this;
  }

  /**
   * The error code provided for the failed job.
   *
   * @return errorCode
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ERROR_CODE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getErrorCode() {
    return errorCode;
  }

  @JsonProperty(value = JSON_PROPERTY_ERROR_CODE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(@javax.annotation.Nullable StringFilterProperty errorCode) {
    this.errorCode = errorCode;
  }

  public JobFilter errorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {

    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * The error message that provides additional context for a failed job.
   *
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getErrorMessage() {
    return errorMessage;
  }

  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    this.errorMessage = errorMessage;
  }

  public JobFilter hasFailedWithRetriesLeft(
      @javax.annotation.Nullable Boolean hasFailedWithRetriesLeft) {

    this.hasFailedWithRetriesLeft = hasFailedWithRetriesLeft;
    return this;
  }

  /**
   * Indicates whether the job has failed with retries left.
   *
   * @return hasFailedWithRetriesLeft
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getHasFailedWithRetriesLeft() {
    return hasFailedWithRetriesLeft;
  }

  @JsonProperty(value = JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFailedWithRetriesLeft(
      @javax.annotation.Nullable Boolean hasFailedWithRetriesLeft) {
    this.hasFailedWithRetriesLeft = hasFailedWithRetriesLeft;
  }

  public JobFilter isDenied(@javax.annotation.Nullable Boolean isDenied) {

    this.isDenied = isDenied;
    return this;
  }

  /**
   * Indicates whether the user task listener denies the work.
   *
   * @return isDenied
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_IS_DENIED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsDenied() {
    return isDenied;
  }

  @JsonProperty(value = JSON_PROPERTY_IS_DENIED, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsDenied(@javax.annotation.Nullable Boolean isDenied) {
    this.isDenied = isDenied;
  }

  public JobFilter jobKey(@javax.annotation.Nullable JobKeyFilterProperty jobKey) {

    this.jobKey = jobKey;
    return this;
  }

  /**
   * The key, a unique identifier for the job.
   *
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_JOB_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobKeyFilterProperty getJobKey() {
    return jobKey;
  }

  @JsonProperty(value = JSON_PROPERTY_JOB_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(@javax.annotation.Nullable JobKeyFilterProperty jobKey) {
    this.jobKey = jobKey;
  }

  public JobFilter kind(@javax.annotation.Nullable JobKindFilterProperty kind) {

    this.kind = kind;
    return this;
  }

  /**
   * The kind of the job.
   *
   * @return kind
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_KIND, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobKindFilterProperty getKind() {
    return kind;
  }

  @JsonProperty(value = JSON_PROPERTY_KIND, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKind(@javax.annotation.Nullable JobKindFilterProperty kind) {
    this.kind = kind;
  }

  public JobFilter listenerEventType(
      @javax.annotation.Nullable JobListenerEventTypeFilterProperty listenerEventType) {

    this.listenerEventType = listenerEventType;
    return this;
  }

  /**
   * The listener event type of the job.
   *
   * @return listenerEventType
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_LISTENER_EVENT_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobListenerEventTypeFilterProperty getListenerEventType() {
    return listenerEventType;
  }

  @JsonProperty(value = JSON_PROPERTY_LISTENER_EVENT_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListenerEventType(
      @javax.annotation.Nullable JobListenerEventTypeFilterProperty listenerEventType) {
    this.listenerEventType = listenerEventType;
  }

  public JobFilter processDefinitionId(
      @javax.annotation.Nullable StringFilterProperty processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated with the job.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(
      @javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public JobFilter processDefinitionKey(
      @javax.annotation.Nullable ProcessDefinitionKeyFilterProperty processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated with the job.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessDefinitionKeyFilterProperty getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(
      @javax.annotation.Nullable ProcessDefinitionKeyFilterProperty processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public JobFilter processInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated with the job.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessInstanceKeyFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public JobFilter retries(@javax.annotation.Nullable IntegerFilterProperty retries) {

    this.retries = retries;
    return this;
  }

  /**
   * The number of retries left.
   *
   * @return retries
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_RETRIES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IntegerFilterProperty getRetries() {
    return retries;
  }

  @JsonProperty(value = JSON_PROPERTY_RETRIES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(@javax.annotation.Nullable IntegerFilterProperty retries) {
    this.retries = retries;
  }

  public JobFilter state(@javax.annotation.Nullable JobStateFilterProperty state) {

    this.state = state;
    return this;
  }

  /**
   * The state of the job.
   *
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobStateFilterProperty getState() {
    return state;
  }

  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable JobStateFilterProperty state) {
    this.state = state;
  }

  public JobFilter tenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public JobFilter type(@javax.annotation.Nullable StringFilterProperty type) {

    this.type = type;
    return this;
  }

  /**
   * The type of the job.
   *
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getType() {
    return type;
  }

  @JsonProperty(value = JSON_PROPERTY_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable StringFilterProperty type) {
    this.type = type;
  }

  public JobFilter worker(@javax.annotation.Nullable StringFilterProperty worker) {

    this.worker = worker;
    return this;
  }

  /**
   * The name of the worker for this job.
   *
   * @return worker
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_WORKER, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getWorker() {
    return worker;
  }

  @JsonProperty(value = JSON_PROPERTY_WORKER, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorker(@javax.annotation.Nullable StringFilterProperty worker) {
    this.worker = worker;
  }

  public JobFilter creationTime(@javax.annotation.Nullable DateTimeFilterProperty creationTime) {

    this.creationTime = creationTime;
    return this;
  }

  /**
   * When the job was created. Field is present for jobs created after 8.9.
   *
   * @return creationTime
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CREATION_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getCreationTime() {
    return creationTime;
  }

  @JsonProperty(value = JSON_PROPERTY_CREATION_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationTime(@javax.annotation.Nullable DateTimeFilterProperty creationTime) {
    this.creationTime = creationTime;
  }

  public JobFilter lastUpdateTime(
      @javax.annotation.Nullable DateTimeFilterProperty lastUpdateTime) {

    this.lastUpdateTime = lastUpdateTime;
    return this;
  }

  /**
   * When the job was last updated. Field is present for jobs created after 8.9.
   *
   * @return lastUpdateTime
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_LAST_UPDATE_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getLastUpdateTime() {
    return lastUpdateTime;
  }

  @JsonProperty(value = JSON_PROPERTY_LAST_UPDATE_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdateTime(@javax.annotation.Nullable DateTimeFilterProperty lastUpdateTime) {
    this.lastUpdateTime = lastUpdateTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobFilter jobFilter = (JobFilter) o;
    return Objects.equals(this.deadline, jobFilter.deadline)
        && Objects.equals(this.deniedReason, jobFilter.deniedReason)
        && Objects.equals(this.elementId, jobFilter.elementId)
        && Objects.equals(this.elementInstanceKey, jobFilter.elementInstanceKey)
        && Objects.equals(this.endTime, jobFilter.endTime)
        && Objects.equals(this.errorCode, jobFilter.errorCode)
        && Objects.equals(this.errorMessage, jobFilter.errorMessage)
        && Objects.equals(this.hasFailedWithRetriesLeft, jobFilter.hasFailedWithRetriesLeft)
        && Objects.equals(this.isDenied, jobFilter.isDenied)
        && Objects.equals(this.jobKey, jobFilter.jobKey)
        && Objects.equals(this.kind, jobFilter.kind)
        && Objects.equals(this.listenerEventType, jobFilter.listenerEventType)
        && Objects.equals(this.processDefinitionId, jobFilter.processDefinitionId)
        && Objects.equals(this.processDefinitionKey, jobFilter.processDefinitionKey)
        && Objects.equals(this.processInstanceKey, jobFilter.processInstanceKey)
        && Objects.equals(this.retries, jobFilter.retries)
        && Objects.equals(this.state, jobFilter.state)
        && Objects.equals(this.tenantId, jobFilter.tenantId)
        && Objects.equals(this.type, jobFilter.type)
        && Objects.equals(this.worker, jobFilter.worker)
        && Objects.equals(this.creationTime, jobFilter.creationTime)
        && Objects.equals(this.lastUpdateTime, jobFilter.lastUpdateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        deadline,
        deniedReason,
        elementId,
        elementInstanceKey,
        endTime,
        errorCode,
        errorMessage,
        hasFailedWithRetriesLeft,
        isDenied,
        jobKey,
        kind,
        listenerEventType,
        processDefinitionId,
        processDefinitionKey,
        processInstanceKey,
        retries,
        state,
        tenantId,
        type,
        worker,
        creationTime,
        lastUpdateTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobFilter {\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    deniedReason: ").append(toIndentedString(deniedReason)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    hasFailedWithRetriesLeft: ")
        .append(toIndentedString(hasFailedWithRetriesLeft))
        .append("\n");
    sb.append("    isDenied: ").append(toIndentedString(isDenied)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    listenerEventType: ").append(toIndentedString(listenerEventType)).append("\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    lastUpdateTime: ").append(toIndentedString(lastUpdateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
