/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** Incident search filter. */
@JsonPropertyOrder({
  IncidentFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  IncidentFilter.JSON_PROPERTY_ERROR_TYPE,
  IncidentFilter.JSON_PROPERTY_ERROR_MESSAGE,
  IncidentFilter.JSON_PROPERTY_ELEMENT_ID,
  IncidentFilter.JSON_PROPERTY_CREATION_TIME,
  IncidentFilter.JSON_PROPERTY_STATE,
  IncidentFilter.JSON_PROPERTY_TENANT_ID,
  IncidentFilter.JSON_PROPERTY_INCIDENT_KEY,
  IncidentFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  IncidentFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  IncidentFilter.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  IncidentFilter.JSON_PROPERTY_JOB_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class IncidentFilter {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
  @javax.annotation.Nullable private IncidentErrorTypeFilterProperty errorType;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable private StringFilterProperty errorMessage;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable private StringFilterProperty elementId;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  @javax.annotation.Nullable private DateTimeFilterProperty creationTime;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable private IncidentStateFilterProperty state;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_INCIDENT_KEY = "incidentKey";
  @javax.annotation.Nullable private BasicStringFilterProperty incidentKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable private ProcessDefinitionKeyFilterProperty processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable private ProcessInstanceKeyFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable private ElementInstanceKeyFilterProperty elementInstanceKey;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  @javax.annotation.Nullable private JobKeyFilterProperty jobKey;

  public IncidentFilter() {}

  public IncidentFilter processDefinitionId(
      @javax.annotation.Nullable StringFilterProperty processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated to this incident.
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(
      @javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public IncidentFilter errorType(
      @javax.annotation.Nullable IncidentErrorTypeFilterProperty errorType) {

    this.errorType = errorType;
    return this;
  }

  /**
   * Incident error type with a defined set of values.
   *
   * @return errorType
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ERROR_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IncidentErrorTypeFilterProperty getErrorType() {
    return errorType;
  }

  @JsonProperty(value = JSON_PROPERTY_ERROR_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorType(@javax.annotation.Nullable IncidentErrorTypeFilterProperty errorType) {
    this.errorType = errorType;
  }

  public IncidentFilter errorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {

    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * The error message of this incident.
   *
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getErrorMessage() {
    return errorMessage;
  }

  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IncidentFilter elementId(@javax.annotation.Nullable StringFilterProperty elementId) {

    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID associated to this incident.
   *
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getElementId() {
    return elementId;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    this.elementId = elementId;
  }

  public IncidentFilter creationTime(
      @javax.annotation.Nullable DateTimeFilterProperty creationTime) {

    this.creationTime = creationTime;
    return this;
  }

  /**
   * Date of incident creation.
   *
   * @return creationTime
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_CREATION_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DateTimeFilterProperty getCreationTime() {
    return creationTime;
  }

  @JsonProperty(value = JSON_PROPERTY_CREATION_TIME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationTime(@javax.annotation.Nullable DateTimeFilterProperty creationTime) {
    this.creationTime = creationTime;
  }

  public IncidentFilter state(@javax.annotation.Nullable IncidentStateFilterProperty state) {

    this.state = state;
    return this;
  }

  /**
   * State of this incident with a defined set of values.
   *
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IncidentStateFilterProperty getState() {
    return state;
  }

  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable IncidentStateFilterProperty state) {
    this.state = state;
  }

  public IncidentFilter tenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the incident.
   *
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StringFilterProperty getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public IncidentFilter incidentKey(
      @javax.annotation.Nullable BasicStringFilterProperty incidentKey) {

    this.incidentKey = incidentKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this incident.
   *
   * @return incidentKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_INCIDENT_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BasicStringFilterProperty getIncidentKey() {
    return incidentKey;
  }

  @JsonProperty(value = JSON_PROPERTY_INCIDENT_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentKey(@javax.annotation.Nullable BasicStringFilterProperty incidentKey) {
    this.incidentKey = incidentKey;
  }

  public IncidentFilter processDefinitionKey(
      @javax.annotation.Nullable ProcessDefinitionKeyFilterProperty processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this incident.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessDefinitionKeyFilterProperty getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(
      @javax.annotation.Nullable ProcessDefinitionKeyFilterProperty processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public IncidentFilter processInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this incident.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProcessInstanceKeyFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(
      @javax.annotation.Nullable ProcessInstanceKeyFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public IncidentFilter elementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty elementInstanceKey) {

    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The element instance key associated to this incident.
   *
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ElementInstanceKeyFilterProperty getElementInstanceKey() {
    return elementInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ELEMENT_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(
      @javax.annotation.Nullable ElementInstanceKeyFilterProperty elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public IncidentFilter jobKey(@javax.annotation.Nullable JobKeyFilterProperty jobKey) {

    this.jobKey = jobKey;
    return this;
  }

  /**
   * The job key, if exists, associated with this incident.
   *
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_JOB_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JobKeyFilterProperty getJobKey() {
    return jobKey;
  }

  @JsonProperty(value = JSON_PROPERTY_JOB_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(@javax.annotation.Nullable JobKeyFilterProperty jobKey) {
    this.jobKey = jobKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentFilter incidentFilter = (IncidentFilter) o;
    return Objects.equals(this.processDefinitionId, incidentFilter.processDefinitionId)
        && Objects.equals(this.errorType, incidentFilter.errorType)
        && Objects.equals(this.errorMessage, incidentFilter.errorMessage)
        && Objects.equals(this.elementId, incidentFilter.elementId)
        && Objects.equals(this.creationTime, incidentFilter.creationTime)
        && Objects.equals(this.state, incidentFilter.state)
        && Objects.equals(this.tenantId, incidentFilter.tenantId)
        && Objects.equals(this.incidentKey, incidentFilter.incidentKey)
        && Objects.equals(this.processDefinitionKey, incidentFilter.processDefinitionKey)
        && Objects.equals(this.processInstanceKey, incidentFilter.processInstanceKey)
        && Objects.equals(this.elementInstanceKey, incidentFilter.elementInstanceKey)
        && Objects.equals(this.jobKey, incidentFilter.jobKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        processDefinitionId,
        errorType,
        errorMessage,
        elementId,
        creationTime,
        state,
        tenantId,
        incidentKey,
        processDefinitionKey,
        processInstanceKey,
        elementInstanceKey,
        jobKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentFilter {\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    incidentKey: ").append(toIndentedString(incidentKey)).append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
