/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/** CreateProcessInstanceResult */
@JsonPropertyOrder({
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  CreateProcessInstanceResult.JSON_PROPERTY_TENANT_ID,
  CreateProcessInstanceResult.JSON_PROPERTY_VARIABLES,
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  CreateProcessInstanceResult.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class CreateProcessInstanceResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nonnull private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nonnull private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nonnull private String tenantId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nonnull private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nonnull private String processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nonnull private String processInstanceKey;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable private Set<String> tags = new LinkedHashSet<>();

  public CreateProcessInstanceResult() {}

  public CreateProcessInstanceResult processDefinitionId(
      @javax.annotation.Nonnull String processDefinitionId) {

    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The BPMN process id of the process definition which was used to create the process. instance
   *
   * @return processDefinitionId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionId(@javax.annotation.Nonnull String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public CreateProcessInstanceResult processDefinitionVersion(
      @javax.annotation.Nonnull Integer processDefinitionVersion) {

    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the process definition which was used to create the process instance.
   *
   * @return processDefinitionVersion
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionVersion(
      @javax.annotation.Nonnull Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public CreateProcessInstanceResult tenantId(@javax.annotation.Nonnull String tenantId) {

    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the created process instance.
   *
   * @return tenantId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTenantId() {
    return tenantId;
  }

  @JsonProperty(value = JSON_PROPERTY_TENANT_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTenantId(@javax.annotation.Nonnull String tenantId) {
    this.tenantId = tenantId;
  }

  public CreateProcessInstanceResult variables(
      @javax.annotation.Nonnull Map<String, Object> variables) {

    this.variables = variables;
    return this;
  }

  public CreateProcessInstanceResult putVariablesItem(String key, Object variablesItem) {
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All the variables visible in the root scope.
   *
   * @return variables
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = true)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.ALWAYS)
  public Map<String, Object> getVariables() {
    return variables;
  }

  @JsonProperty(value = JSON_PROPERTY_VARIABLES, required = true)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.ALWAYS)
  public void setVariables(@javax.annotation.Nonnull Map<String, Object> variables) {
    this.variables = variables;
  }

  public CreateProcessInstanceResult processDefinitionKey(
      @javax.annotation.Nonnull String processDefinitionKey) {

    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition which was used to create the process instance.
   *
   * @return processDefinitionKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_DEFINITION_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessDefinitionKey(@javax.annotation.Nonnull String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public CreateProcessInstanceResult processInstanceKey(
      @javax.annotation.Nonnull String processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The unique identifier of the created process instance; to be used wherever a request needs a
   * process instance key (e.g. CancelProcessInstanceRequest).
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProcessInstanceKey(@javax.annotation.Nonnull String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public CreateProcessInstanceResult tags(@javax.annotation.Nullable Set<String> tags) {

    this.tags = tags;
    return this;
  }

  public CreateProcessInstanceResult addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags. Tags need to start with a letter; then alphanumerics, &#x60;_&#x60;,
   * &#x60;-&#x60;, &#x60;:&#x60;, or &#x60;.&#x60;; length ≤ 100.
   *
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Set<String> getTags() {
    return tags;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(value = JSON_PROPERTY_TAGS, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateProcessInstanceResult createProcessInstanceResult = (CreateProcessInstanceResult) o;
    return Objects.equals(this.processDefinitionId, createProcessInstanceResult.processDefinitionId)
        && Objects.equals(
            this.processDefinitionVersion, createProcessInstanceResult.processDefinitionVersion)
        && Objects.equals(this.tenantId, createProcessInstanceResult.tenantId)
        && Objects.equals(this.variables, createProcessInstanceResult.variables)
        && Objects.equals(
            this.processDefinitionKey, createProcessInstanceResult.processDefinitionKey)
        && Objects.equals(this.processInstanceKey, createProcessInstanceResult.processInstanceKey)
        && Objects.equals(this.tags, createProcessInstanceResult.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        processDefinitionId,
        processDefinitionVersion,
        tenantId,
        variables,
        processDefinitionKey,
        processInstanceKey,
        tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateProcessInstanceResult {\n");
    sb.append("    processDefinitionId: ")
        .append(toIndentedString(processDefinitionId))
        .append("\n");
    sb.append("    processDefinitionVersion: ")
        .append(toIndentedString(processDefinitionVersion))
        .append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processDefinitionKey: ")
        .append(toIndentedString(processDefinitionKey))
        .append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
