/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Provides information on a broker node. */
@JsonPropertyOrder({
  BrokerInfo.JSON_PROPERTY_NODE_ID,
  BrokerInfo.JSON_PROPERTY_HOST,
  BrokerInfo.JSON_PROPERTY_PORT,
  BrokerInfo.JSON_PROPERTY_PARTITIONS,
  BrokerInfo.JSON_PROPERTY_VERSION
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class BrokerInfo {
  public static final String JSON_PROPERTY_NODE_ID = "nodeId";
  @javax.annotation.Nonnull private Integer nodeId;

  public static final String JSON_PROPERTY_HOST = "host";
  @javax.annotation.Nonnull private String host;

  public static final String JSON_PROPERTY_PORT = "port";
  @javax.annotation.Nonnull private Integer port;

  public static final String JSON_PROPERTY_PARTITIONS = "partitions";
  @javax.annotation.Nonnull private List<Partition> partitions = new ArrayList<>();

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nonnull private String version;

  public BrokerInfo() {}

  public BrokerInfo nodeId(@javax.annotation.Nonnull Integer nodeId) {

    this.nodeId = nodeId;
    return this;
  }

  /**
   * The unique (within a cluster) node ID for the broker.
   *
   * @return nodeId
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_NODE_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getNodeId() {
    return nodeId;
  }

  @JsonProperty(value = JSON_PROPERTY_NODE_ID, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNodeId(@javax.annotation.Nonnull Integer nodeId) {
    this.nodeId = nodeId;
  }

  public BrokerInfo host(@javax.annotation.Nonnull String host) {

    this.host = host;
    return this;
  }

  /**
   * The hostname for reaching the broker.
   *
   * @return host
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_HOST, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getHost() {
    return host;
  }

  @JsonProperty(value = JSON_PROPERTY_HOST, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHost(@javax.annotation.Nonnull String host) {
    this.host = host;
  }

  public BrokerInfo port(@javax.annotation.Nonnull Integer port) {

    this.port = port;
    return this;
  }

  /**
   * The port for reaching the broker.
   *
   * @return port
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PORT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getPort() {
    return port;
  }

  @JsonProperty(value = JSON_PROPERTY_PORT, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPort(@javax.annotation.Nonnull Integer port) {
    this.port = port;
  }

  public BrokerInfo partitions(@javax.annotation.Nonnull List<Partition> partitions) {

    this.partitions = partitions;
    return this;
  }

  public BrokerInfo addPartitionsItem(Partition partitionsItem) {
    if (this.partitions == null) {
      this.partitions = new ArrayList<>();
    }
    this.partitions.add(partitionsItem);
    return this;
  }

  /**
   * A list of partitions managed or replicated on this broker.
   *
   * @return partitions
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_PARTITIONS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<Partition> getPartitions() {
    return partitions;
  }

  @JsonProperty(value = JSON_PROPERTY_PARTITIONS, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPartitions(@javax.annotation.Nonnull List<Partition> partitions) {
    this.partitions = partitions;
  }

  public BrokerInfo version(@javax.annotation.Nonnull String version) {

    this.version = version;
    return this;
  }

  /**
   * The broker version.
   *
   * @return version
   */
  @javax.annotation.Nonnull
  @JsonProperty(value = JSON_PROPERTY_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getVersion() {
    return version;
  }

  @JsonProperty(value = JSON_PROPERTY_VERSION, required = true)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVersion(@javax.annotation.Nonnull String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrokerInfo brokerInfo = (BrokerInfo) o;
    return Objects.equals(this.nodeId, brokerInfo.nodeId)
        && Objects.equals(this.host, brokerInfo.host)
        && Objects.equals(this.port, brokerInfo.port)
        && Objects.equals(this.partitions, brokerInfo.partitions)
        && Objects.equals(this.version, brokerInfo.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nodeId, host, port, partitions, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BrokerInfo {\n");
    sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    partitions: ").append(toIndentedString(partitions)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
