/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

/** BatchOperationItemResponse */
@JsonPropertyOrder({
  BatchOperationItemResponse.JSON_PROPERTY_OPERATION_TYPE,
  BatchOperationItemResponse.JSON_PROPERTY_BATCH_OPERATION_KEY,
  BatchOperationItemResponse.JSON_PROPERTY_ITEM_KEY,
  BatchOperationItemResponse.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  BatchOperationItemResponse.JSON_PROPERTY_STATE,
  BatchOperationItemResponse.JSON_PROPERTY_PROCESSED_DATE,
  BatchOperationItemResponse.JSON_PROPERTY_ERROR_MESSAGE
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class BatchOperationItemResponse {
  public static final String JSON_PROPERTY_OPERATION_TYPE = "operationType";
  @javax.annotation.Nullable private BatchOperationTypeEnum operationType;

  public static final String JSON_PROPERTY_BATCH_OPERATION_KEY = "batchOperationKey";
  @javax.annotation.Nullable private String batchOperationKey;

  public static final String JSON_PROPERTY_ITEM_KEY = "itemKey";
  @javax.annotation.Nullable private String itemKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable private String processInstanceKey;

  /** State of the item. */
  public enum StateEnum {
    ACTIVE(String.valueOf("ACTIVE")),

    COMPLETED(String.valueOf("COMPLETED")),

    SKIPPED(String.valueOf("SKIPPED")),

    CANCELED(String.valueOf("CANCELED")),

    FAILED(String.valueOf("FAILED")),

    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable private StateEnum state;

  public static final String JSON_PROPERTY_PROCESSED_DATE = "processedDate";
  @javax.annotation.Nullable private String processedDate;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable private String errorMessage;

  public BatchOperationItemResponse() {}

  public BatchOperationItemResponse operationType(
      @javax.annotation.Nullable BatchOperationTypeEnum operationType) {

    this.operationType = operationType;
    return this;
  }

  /**
   * Get operationType
   *
   * @return operationType
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_OPERATION_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BatchOperationTypeEnum getOperationType() {
    return operationType;
  }

  @JsonProperty(value = JSON_PROPERTY_OPERATION_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationType(@javax.annotation.Nullable BatchOperationTypeEnum operationType) {
    this.operationType = operationType;
  }

  public BatchOperationItemResponse batchOperationKey(
      @javax.annotation.Nullable String batchOperationKey) {

    this.batchOperationKey = batchOperationKey;
    return this;
  }

  /**
   * The key (or operate legacy ID) of the batch operation.
   *
   * @return batchOperationKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_BATCH_OPERATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBatchOperationKey() {
    return batchOperationKey;
  }

  @JsonProperty(value = JSON_PROPERTY_BATCH_OPERATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationKey(@javax.annotation.Nullable String batchOperationKey) {
    this.batchOperationKey = batchOperationKey;
  }

  public BatchOperationItemResponse itemKey(@javax.annotation.Nullable String itemKey) {

    this.itemKey = itemKey;
    return this;
  }

  /**
   * Key of the item, e.g. a process instance key.
   *
   * @return itemKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ITEM_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getItemKey() {
    return itemKey;
  }

  @JsonProperty(value = JSON_PROPERTY_ITEM_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemKey(@javax.annotation.Nullable String itemKey) {
    this.itemKey = itemKey;
  }

  public BatchOperationItemResponse processInstanceKey(
      @javax.annotation.Nullable String processInstanceKey) {

    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * the process instance key of the processed item.
   *
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProcessInstanceKey() {
    return processInstanceKey;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESS_INSTANCE_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public BatchOperationItemResponse state(@javax.annotation.Nullable StateEnum state) {

    this.state = state;
    return this;
  }

  /**
   * State of the item.
   *
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public StateEnum getState() {
    return state;
  }

  @JsonProperty(value = JSON_PROPERTY_STATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable StateEnum state) {
    this.state = state;
  }

  public BatchOperationItemResponse processedDate(@javax.annotation.Nullable String processedDate) {

    this.processedDate = processedDate;
    return this;
  }

  /**
   * the date this item was processed.
   *
   * @return processedDate
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PROCESSED_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProcessedDate() {
    return processedDate;
  }

  @JsonProperty(value = JSON_PROPERTY_PROCESSED_DATE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessedDate(@javax.annotation.Nullable String processedDate) {
    this.processedDate = processedDate;
  }

  public BatchOperationItemResponse errorMessage(@javax.annotation.Nullable String errorMessage) {

    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * the error message from the engine in case of a failed operation.
   *
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getErrorMessage() {
    return errorMessage;
  }

  @JsonProperty(value = JSON_PROPERTY_ERROR_MESSAGE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable String errorMessage) {
    this.errorMessage = errorMessage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchOperationItemResponse batchOperationItemResponse = (BatchOperationItemResponse) o;
    return Objects.equals(this.operationType, batchOperationItemResponse.operationType)
        && Objects.equals(this.batchOperationKey, batchOperationItemResponse.batchOperationKey)
        && Objects.equals(this.itemKey, batchOperationItemResponse.itemKey)
        && Objects.equals(this.processInstanceKey, batchOperationItemResponse.processInstanceKey)
        && Objects.equals(this.state, batchOperationItemResponse.state)
        && Objects.equals(this.processedDate, batchOperationItemResponse.processedDate)
        && Objects.equals(this.errorMessage, batchOperationItemResponse.errorMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        operationType,
        batchOperationKey,
        itemKey,
        processInstanceKey,
        state,
        processedDate,
        errorMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchOperationItemResponse {\n");
    sb.append("    operationType: ").append(toIndentedString(operationType)).append("\n");
    sb.append("    batchOperationKey: ").append(toIndentedString(batchOperationKey)).append("\n");
    sb.append("    itemKey: ").append(toIndentedString(itemKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    processedDate: ").append(toIndentedString(processedDate)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
