/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** AuthorizationResult */
@JsonPropertyOrder({
  AuthorizationResult.JSON_PROPERTY_OWNER_ID,
  AuthorizationResult.JSON_PROPERTY_OWNER_TYPE,
  AuthorizationResult.JSON_PROPERTY_RESOURCE_TYPE,
  AuthorizationResult.JSON_PROPERTY_RESOURCE_ID,
  AuthorizationResult.JSON_PROPERTY_RESOURCE_PROPERTY_NAME,
  AuthorizationResult.JSON_PROPERTY_PERMISSION_TYPES,
  AuthorizationResult.JSON_PROPERTY_AUTHORIZATION_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(
    com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2026-02-04T11:41:20.493678380Z[UTC]",
    comments = "Generator version: 7.18.0")
public class AuthorizationResult {
  public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
  @javax.annotation.Nullable private String ownerId;

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  @javax.annotation.Nullable private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  @javax.annotation.Nullable private ResourceTypeEnum resourceType;

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  @javax.annotation.Nullable private String resourceId;

  public static final String JSON_PROPERTY_RESOURCE_PROPERTY_NAME = "resourcePropertyName";
  @javax.annotation.Nullable private String resourcePropertyName;

  public static final String JSON_PROPERTY_PERMISSION_TYPES = "permissionTypes";
  @javax.annotation.Nullable private List<PermissionTypeEnum> permissionTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_AUTHORIZATION_KEY = "authorizationKey";
  @javax.annotation.Nullable private String authorizationKey;

  public AuthorizationResult() {}

  public AuthorizationResult ownerId(@javax.annotation.Nullable String ownerId) {

    this.ownerId = ownerId;
    return this;
  }

  /**
   * The ID of the owner of permissions.
   *
   * @return ownerId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_OWNER_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOwnerId() {
    return ownerId;
  }

  @JsonProperty(value = JSON_PROPERTY_OWNER_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerId(@javax.annotation.Nullable String ownerId) {
    this.ownerId = ownerId;
  }

  public AuthorizationResult ownerType(@javax.annotation.Nullable OwnerTypeEnum ownerType) {

    this.ownerType = ownerType;
    return this;
  }

  /**
   * Get ownerType
   *
   * @return ownerType
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_OWNER_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }

  @JsonProperty(value = JSON_PROPERTY_OWNER_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerType(@javax.annotation.Nullable OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }

  public AuthorizationResult resourceType(
      @javax.annotation.Nullable ResourceTypeEnum resourceType) {

    this.resourceType = resourceType;
    return this;
  }

  /**
   * The type of resource that the permissions relate to.
   *
   * @return resourceType
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_RESOURCE_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ResourceTypeEnum getResourceType() {
    return resourceType;
  }

  @JsonProperty(value = JSON_PROPERTY_RESOURCE_TYPE, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceType(@javax.annotation.Nullable ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
  }

  public AuthorizationResult resourceId(@javax.annotation.Nullable String resourceId) {

    this.resourceId = resourceId;
    return this;
  }

  /**
   * ID of the resource the permission relates to (mutually exclusive with
   * &#x60;resourcePropertyName&#x60;).
   *
   * @return resourceId
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_RESOURCE_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getResourceId() {
    return resourceId;
  }

  @JsonProperty(value = JSON_PROPERTY_RESOURCE_ID, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceId(@javax.annotation.Nullable String resourceId) {
    this.resourceId = resourceId;
  }

  public AuthorizationResult resourcePropertyName(
      @javax.annotation.Nullable String resourcePropertyName) {

    this.resourcePropertyName = resourcePropertyName;
    return this;
  }

  /**
   * The name of the resource property the permission relates to (mutually exclusive with
   * &#x60;resourceId&#x60;).
   *
   * @return resourcePropertyName
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_RESOURCE_PROPERTY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getResourcePropertyName() {
    return resourcePropertyName;
  }

  @JsonProperty(value = JSON_PROPERTY_RESOURCE_PROPERTY_NAME, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourcePropertyName(@javax.annotation.Nullable String resourcePropertyName) {
    this.resourcePropertyName = resourcePropertyName;
  }

  public AuthorizationResult permissionTypes(
      @javax.annotation.Nullable List<PermissionTypeEnum> permissionTypes) {

    this.permissionTypes = permissionTypes;
    return this;
  }

  public AuthorizationResult addPermissionTypesItem(PermissionTypeEnum permissionTypesItem) {
    if (this.permissionTypes == null) {
      this.permissionTypes = new ArrayList<>();
    }
    this.permissionTypes.add(permissionTypesItem);
    return this;
  }

  /**
   * Specifies the types of the permissions.
   *
   * @return permissionTypes
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_PERMISSION_TYPES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<PermissionTypeEnum> getPermissionTypes() {
    return permissionTypes;
  }

  @JsonProperty(value = JSON_PROPERTY_PERMISSION_TYPES, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermissionTypes(
      @javax.annotation.Nullable List<PermissionTypeEnum> permissionTypes) {
    this.permissionTypes = permissionTypes;
  }

  public AuthorizationResult authorizationKey(@javax.annotation.Nullable String authorizationKey) {

    this.authorizationKey = authorizationKey;
    return this;
  }

  /**
   * The key of the authorization.
   *
   * @return authorizationKey
   */
  @javax.annotation.Nullable
  @JsonProperty(value = JSON_PROPERTY_AUTHORIZATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAuthorizationKey() {
    return authorizationKey;
  }

  @JsonProperty(value = JSON_PROPERTY_AUTHORIZATION_KEY, required = false)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthorizationKey(@javax.annotation.Nullable String authorizationKey) {
    this.authorizationKey = authorizationKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationResult authorizationResult = (AuthorizationResult) o;
    return Objects.equals(this.ownerId, authorizationResult.ownerId)
        && Objects.equals(this.ownerType, authorizationResult.ownerType)
        && Objects.equals(this.resourceType, authorizationResult.resourceType)
        && Objects.equals(this.resourceId, authorizationResult.resourceId)
        && Objects.equals(this.resourcePropertyName, authorizationResult.resourcePropertyName)
        && Objects.equals(this.permissionTypes, authorizationResult.permissionTypes)
        && Objects.equals(this.authorizationKey, authorizationResult.authorizationKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        ownerId,
        ownerType,
        resourceType,
        resourceId,
        resourcePropertyName,
        permissionTypes,
        authorizationKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationResult {\n");
    sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourcePropertyName: ")
        .append(toIndentedString(resourcePropertyName))
        .append("\n");
    sb.append("    permissionTypes: ").append(toIndentedString(permissionTypes)).append("\n");
    sb.append("    authorizationKey: ").append(toIndentedString(authorizationKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
