/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"jobKey", "processInstanceKey", "processDefinitionKey", "elementInstanceKey", "type", "processDefinitionId", "processDefinitionVersion", "elementId", "customHeaders", "worker", "retries", "deadline", "variables", "tenantId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActivatedJobResult {
    public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
    private String jobKey;
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
    private String processInstanceKey;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private String processDefinitionKey;
    public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
    private String elementInstanceKey;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private String processDefinitionId;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
    private Integer processDefinitionVersion;
    public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
    private String elementId;
    public static final String JSON_PROPERTY_CUSTOM_HEADERS = "customHeaders";
    private Map<String, Object> customHeaders = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_WORKER = "worker";
    private String worker;
    public static final String JSON_PROPERTY_RETRIES = "retries";
    private Integer retries;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    private Long deadline;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId;

    public ActivatedJobResult jobKey(String jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="jobKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobKey() {
        return this.jobKey;
    }

    @JsonProperty(value="jobKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobKey(String jobKey) {
        this.jobKey = jobKey;
    }

    public ActivatedJobResult processInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public ActivatedJobResult processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="processDefinitionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public ActivatedJobResult elementInstanceKey(String elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="elementInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @JsonProperty(value="elementInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setElementInstanceKey(String elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public ActivatedJobResult type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public ActivatedJobResult processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ActivatedJobResult processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @JsonProperty(value="processDefinitionVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public ActivatedJobResult elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @Nullable
    @JsonProperty(value="elementId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getElementId() {
        return this.elementId;
    }

    @JsonProperty(value="elementId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public ActivatedJobResult customHeaders(Map<String, Object> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public ActivatedJobResult putCustomHeadersItem(String key, Object customHeadersItem) {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, Object>();
        }
        this.customHeaders.put(key, customHeadersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="customHeaders")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getCustomHeaders() {
        return this.customHeaders;
    }

    @JsonProperty(value="customHeaders")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomHeaders(Map<String, Object> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public ActivatedJobResult worker(String worker) {
        this.worker = worker;
        return this;
    }

    @Nullable
    @JsonProperty(value="worker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorker() {
        return this.worker;
    }

    @JsonProperty(value="worker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorker(String worker) {
        this.worker = worker;
    }

    public ActivatedJobResult retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @JsonProperty(value="retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public ActivatedJobResult deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @Nullable
    @JsonProperty(value="deadline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDeadline() {
        return this.deadline;
    }

    @JsonProperty(value="deadline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public ActivatedJobResult variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public ActivatedJobResult putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public ActivatedJobResult tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivatedJobResult activatedJobResult = (ActivatedJobResult)o;
        return Objects.equals(this.jobKey, activatedJobResult.jobKey) && Objects.equals(this.processInstanceKey, activatedJobResult.processInstanceKey) && Objects.equals(this.processDefinitionKey, activatedJobResult.processDefinitionKey) && Objects.equals(this.elementInstanceKey, activatedJobResult.elementInstanceKey) && Objects.equals(this.type, activatedJobResult.type) && Objects.equals(this.processDefinitionId, activatedJobResult.processDefinitionId) && Objects.equals(this.processDefinitionVersion, activatedJobResult.processDefinitionVersion) && Objects.equals(this.elementId, activatedJobResult.elementId) && Objects.equals(this.customHeaders, activatedJobResult.customHeaders) && Objects.equals(this.worker, activatedJobResult.worker) && Objects.equals(this.retries, activatedJobResult.retries) && Objects.equals(this.deadline, activatedJobResult.deadline) && Objects.equals(this.variables, activatedJobResult.variables) && Objects.equals(this.tenantId, activatedJobResult.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.jobKey, this.processInstanceKey, this.processDefinitionKey, this.elementInstanceKey, this.type, this.processDefinitionId, this.processDefinitionVersion, this.elementId, this.customHeaders, this.worker, this.retries, this.deadline, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivatedJobResult {\n");
        sb.append("    jobKey: ").append(this.toIndentedString(this.jobKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    elementInstanceKey: ").append(this.toIndentedString(this.elementInstanceKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    elementId: ").append(this.toIndentedString(this.elementId)).append("\n");
        sb.append("    customHeaders: ").append(this.toIndentedString(this.customHeaders)).append("\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionId() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionVersion() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getElementId() != null) {
            try {
                joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getElementId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCustomHeaders() != null) {
            for (String _key : this.getCustomHeaders().keySet()) {
                try {
                    joiner.add(String.format("%scustomHeaders%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustomHeaders().get(_key), URLEncoder.encode(String.valueOf(this.getCustomHeaders().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getWorker() != null) {
            try {
                joiner.add(String.format("%sworker%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWorker()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRetries() != null) {
            try {
                joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRetries()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDeadline() != null) {
            try {
                joiner.add(String.format("%sdeadline%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDeadline()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                try {
                    joiner.add(String.format("%svariables%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getVariables().get(_key), URLEncoder.encode(String.valueOf(this.getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

